/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.api;

import io.openlineage.spark.agent.lifecycle.VisitorFactory;
import io.openlineage.spark.api.OpenLineageEventHandlerFactory;
import io.openlineage.spark.api.Vendor;
import io.openlineage.spark.api.VendorsImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface Vendors {
    public static final List<String> VENDORS = Arrays.asList("io.openlineage.spark.agent.vendor.snowflake.SnowflakeVendor");

    public static Vendors getVendors() {
        return Vendors.getVendors(Collections.emptyList());
    }

    public static Vendors getVendors(List<String> additionalVendors) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        List<Vendor> vendors = Stream.concat(VENDORS.stream(), additionalVendors.stream()).map(vendorClassName -> {
            try {
                Class<?> vendor = cl.loadClass((String)vendorClassName);
                return (Vendor)vendor.newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                return null;
            }
        }).filter(Objects::nonNull).filter(Vendor::isVendorAvailable).collect(Collectors.toList());
        return new VendorsImpl(vendors);
    }

    public static Vendors empty() {
        return new Vendors(){

            @Override
            public Collection<VisitorFactory> getVisitorFactories() {
                return Collections.emptyList();
            }

            @Override
            public Collection<OpenLineageEventHandlerFactory> getEventHandlerFactories() {
                return Collections.emptyList();
            }
        };
    }

    public Collection<VisitorFactory> getVisitorFactories();

    public Collection<OpenLineageEventHandlerFactory> getEventHandlerFactories();
}

