/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.shaded.org.apache.hc.core5.http.protocol;

import io.openlineage.spark.shaded.org.apache.hc.core5.annotation.Contract;
import io.openlineage.spark.shaded.org.apache.hc.core5.annotation.ThreadingBehavior;
import io.openlineage.spark.shaded.org.apache.hc.core5.http.EntityDetails;
import io.openlineage.spark.shaded.org.apache.hc.core5.http.HttpException;
import io.openlineage.spark.shaded.org.apache.hc.core5.http.HttpRequest;
import io.openlineage.spark.shaded.org.apache.hc.core5.http.HttpRequestInterceptor;
import io.openlineage.spark.shaded.org.apache.hc.core5.http.HttpVersion;
import io.openlineage.spark.shaded.org.apache.hc.core5.http.ProtocolVersion;
import io.openlineage.spark.shaded.org.apache.hc.core5.http.protocol.HttpContext;
import io.openlineage.spark.shaded.org.apache.hc.core5.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    public static final RequestExpectContinue INSTANCE = new RequestExpectContinue();

    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && entity != null) {
            ProtocolVersion ver = context.getProtocolVersion();
            if (entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0)) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

