/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.shaded.org.apache.hc.core5.http.protocol;

import io.openlineage.spark.shaded.org.apache.hc.core5.annotation.Contract;
import io.openlineage.spark.shaded.org.apache.hc.core5.annotation.ThreadingBehavior;
import io.openlineage.spark.shaded.org.apache.hc.core5.http.EntityDetails;
import io.openlineage.spark.shaded.org.apache.hc.core5.http.HttpException;
import io.openlineage.spark.shaded.org.apache.hc.core5.http.HttpResponse;
import io.openlineage.spark.shaded.org.apache.hc.core5.http.HttpResponseInterceptor;
import io.openlineage.spark.shaded.org.apache.hc.core5.http.HttpVersion;
import io.openlineage.spark.shaded.org.apache.hc.core5.http.ProtocolException;
import io.openlineage.spark.shaded.org.apache.hc.core5.http.ProtocolVersion;
import io.openlineage.spark.shaded.org.apache.hc.core5.http.message.MessageSupport;
import io.openlineage.spark.shaded.org.apache.hc.core5.http.protocol.HttpContext;
import io.openlineage.spark.shaded.org.apache.hc.core5.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class ResponseContent
implements HttpResponseInterceptor {
    private final boolean overwrite;

    public ResponseContent() {
        this(false);
    }

    public ResponseContent(boolean overwrite) {
        this.overwrite = overwrite;
    }

    @Override
    public void process(HttpResponse response, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        if (this.overwrite) {
            response.removeHeaders("Transfer-Encoding");
            response.removeHeaders("Content-Length");
        } else {
            if (response.containsHeader("Transfer-Encoding")) {
                throw new ProtocolException("Transfer-encoding header already present");
            }
            if (response.containsHeader("Content-Length")) {
                throw new ProtocolException("Content-Length header already present");
            }
        }
        ProtocolVersion ver = context.getProtocolVersion();
        if (entity != null) {
            long len = entity.getContentLength();
            if (len >= 0L && !entity.isChunked()) {
                response.addHeader("Content-Length", Long.toString(entity.getContentLength()));
            } else if (ver.greaterEquals(HttpVersion.HTTP_1_1)) {
                response.addHeader("Transfer-Encoding", "chunked");
                MessageSupport.addTrailerHeader(response, entity);
            }
            MessageSupport.addContentTypeHeader(response, entity);
            MessageSupport.addContentEncodingHeader(response, entity);
        } else {
            int status = response.getCode();
            if (status != 204 && status != 304) {
                response.addHeader("Content-Length", "0");
            }
        }
    }
}

