/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.shaded.org.apache.hc.core5.http2.impl.nio;

import io.openlineage.spark.shaded.org.apache.hc.core5.annotation.Contract;
import io.openlineage.spark.shaded.org.apache.hc.core5.annotation.Internal;
import io.openlineage.spark.shaded.org.apache.hc.core5.annotation.ThreadingBehavior;
import io.openlineage.spark.shaded.org.apache.hc.core5.concurrent.FutureCallback;
import io.openlineage.spark.shaded.org.apache.hc.core5.http.URIScheme;
import io.openlineage.spark.shaded.org.apache.hc.core5.http.impl.nio.ServerHttp1IOEventHandler;
import io.openlineage.spark.shaded.org.apache.hc.core5.http.impl.nio.ServerHttp1StreamDuplexerFactory;
import io.openlineage.spark.shaded.org.apache.hc.core5.reactor.ProtocolIOSession;
import io.openlineage.spark.shaded.org.apache.hc.core5.reactor.ProtocolUpgradeHandler;
import io.openlineage.spark.shaded.org.apache.hc.core5.reactor.ssl.TlsDetails;
import io.openlineage.spark.shaded.org.apache.hc.core5.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
@Internal
public class ServerHttp1UpgradeHandler
implements ProtocolUpgradeHandler {
    private final ServerHttp1StreamDuplexerFactory http1StreamHandlerFactory;

    public ServerHttp1UpgradeHandler(ServerHttp1StreamDuplexerFactory http1StreamHandlerFactory) {
        this.http1StreamHandlerFactory = Args.notNull(http1StreamHandlerFactory, "HTTP/1.1 stream handler factory");
    }

    @Override
    public void upgrade(ProtocolIOSession ioSession, FutureCallback<ProtocolIOSession> callback) {
        TlsDetails tlsDetails = ioSession.getTlsDetails();
        ServerHttp1IOEventHandler eventHandler = new ServerHttp1IOEventHandler(this.http1StreamHandlerFactory.create(tlsDetails != null ? URIScheme.HTTPS.id : URIScheme.HTTP.id, ioSession));
        ioSession.upgrade(eventHandler);
        ioSession.upgrade(eventHandler);
        try {
            eventHandler.connected(ioSession);
            if (callback != null) {
                callback.completed(ioSession);
            }
        }
        catch (IOException ex) {
            eventHandler.exception(ioSession, ex);
        }
    }
}

