/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark3.agent.lifecycle.plan;

import io.openlineage.client.OpenLineage;
import io.openlineage.spark.agent.util.ExtensionPlanUtils;
import io.openlineage.spark.agent.util.ScalaConversionUtils;
import io.openlineage.spark.api.AbstractQueryPlanInputDatasetBuilder;
import io.openlineage.spark.api.OpenLineageContext;
import io.openlineage.spark.extension.scala.v1.InputDatasetWithDelegate;
import io.openlineage.spark.extension.scala.v1.InputDatasetWithIdentifier;
import io.openlineage.spark.extension.scala.v1.InputLineageNode;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkExtensionV1InputDatasetBuilder
extends AbstractQueryPlanInputDatasetBuilder<LogicalPlan> {
    private static final Logger log = LoggerFactory.getLogger(SparkExtensionV1InputDatasetBuilder.class);

    public SparkExtensionV1InputDatasetBuilder(OpenLineageContext context) {
        super(context, false);
    }

    @Override
    public boolean isDefinedAtLogicalPlan(LogicalPlan logicalPlan) {
        return logicalPlan instanceof InputLineageNode;
    }

    @Override
    protected List<OpenLineage.InputDataset> apply(SparkListenerEvent event, LogicalPlan x) {
        InputLineageNode lineageNode = (InputLineageNode)x;
        List datasets = ScalaConversionUtils.fromSeq(lineageNode.getInputs(ExtensionPlanUtils.context(event, this.context)).toList().toSeq());
        List<OpenLineage.InputDataset> inputDatasets = datasets.stream().filter(d -> d instanceof InputDatasetWithDelegate).map(d -> (InputDatasetWithDelegate)d).map(inputDelegate -> (LogicalPlan)inputDelegate.node()).flatMap(d -> this.delegate(event, (LogicalPlan)d).stream()).collect(Collectors.toList());
        inputDatasets.addAll(datasets.stream().filter(d -> d instanceof InputDatasetWithIdentifier).map(d -> (InputDatasetWithIdentifier)d).map(d -> this.getContext().getOpenLineage().newInputDatasetBuilder().namespace(d.datasetIdentifier().getNamespace()).name(d.datasetIdentifier().getName()).facets(d.facetsBuilder().build()).inputFacets(d.inputFacetsBuilder().build()).build()).collect(Collectors.toList()));
        return inputDatasets;
    }

    protected List<OpenLineage.InputDataset> delegate(SparkListenerEvent event, LogicalPlan plan) {
        return ((List)this.delegate(this.context.getInputDatasetQueryPlanVisitors(), this.context.getInputDatasetBuilders(), event).applyOrElse((Object)plan, ScalaConversionUtils.toScalaFn(lp -> Collections.emptyList()))).stream().collect(Collectors.toList());
    }

    protected OpenLineageContext getContext() {
        return this.context;
    }
}

