/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark3.agent.lifecycle.plan;

import io.openlineage.client.OpenLineage;
import io.openlineage.spark.agent.util.ExtensionPlanUtils;
import io.openlineage.spark.agent.util.ScalaConversionUtils;
import io.openlineage.spark.api.AbstractQueryPlanOutputDatasetBuilder;
import io.openlineage.spark.api.OpenLineageContext;
import io.openlineage.spark.extension.scala.v1.OutputDatasetWithDelegate;
import io.openlineage.spark.extension.scala.v1.OutputDatasetWithIdentifier;
import io.openlineage.spark.extension.scala.v1.OutputLineageNode;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkExtensionV1OutputDatasetBuilder
extends AbstractQueryPlanOutputDatasetBuilder<LogicalPlan> {
    private static final Logger log = LoggerFactory.getLogger(SparkExtensionV1OutputDatasetBuilder.class);

    public SparkExtensionV1OutputDatasetBuilder(OpenLineageContext context) {
        super(context, false);
    }

    @Override
    public boolean isDefinedAtLogicalPlan(LogicalPlan logicalPlan) {
        return logicalPlan instanceof OutputLineageNode;
    }

    @Override
    protected List<OpenLineage.OutputDataset> apply(SparkListenerEvent event, LogicalPlan x) {
        OutputLineageNode lineageNode = (OutputLineageNode)x;
        List datasets = ScalaConversionUtils.fromSeq(lineageNode.getOutputs(ExtensionPlanUtils.context(event, this.context)).toSeq());
        List<OpenLineage.OutputDataset> outputDatasets = datasets.stream().filter(d -> d instanceof OutputDatasetWithDelegate).map(d -> (OutputDatasetWithDelegate)d).map(outputDelegate -> (LogicalPlan)outputDelegate.node()).flatMap(d -> this.delegate(event, (LogicalPlan)d).stream()).collect(Collectors.toList());
        outputDatasets.addAll(datasets.stream().filter(d -> d instanceof OutputDatasetWithIdentifier).map(d -> (OutputDatasetWithIdentifier)d).map(d -> this.getContext().getOpenLineage().newOutputDatasetBuilder().namespace(d.datasetIdentifier().getNamespace()).name(d.datasetIdentifier().getName()).facets(d.facetsBuilder().build()).outputFacets(d.outputFacetsBuilder().build()).build()).collect(Collectors.toList()));
        return outputDatasets;
    }

    protected List<OpenLineage.OutputDataset> delegate(SparkListenerEvent event, LogicalPlan plan) {
        return ((List)this.delegate(this.context.getOutputDatasetQueryPlanVisitors(), this.context.getOutputDatasetBuilders(), event).applyOrElse((Object)plan, ScalaConversionUtils.toScalaFn(lp -> Collections.emptyList()))).stream().collect(Collectors.toList());
    }

    protected OpenLineageContext getContext() {
        return this.context;
    }
}

