/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark3.agent.lifecycle.plan.catalog;

import io.openlineage.client.utils.DatasetIdentifier;
import io.openlineage.spark3.agent.lifecycle.plan.catalog.RelationHandler;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CosmosHandler
implements RelationHandler {
    private static final Logger log = LoggerFactory.getLogger(CosmosHandler.class);

    @Override
    public boolean hasClasses() {
        String COSMOS_CATALOG_NAME = "com.azure.cosmos.spark.CosmosCatalog";
        try {
            CosmosHandler.class.getClassLoader().loadClass(COSMOS_CATALOG_NAME);
            return true;
        }
        catch (Exception exception) {
            try {
                Thread.currentThread().getContextClassLoader().loadClass(COSMOS_CATALOG_NAME);
                return true;
            }
            catch (Exception exception2) {
                return false;
            }
        }
    }

    @Override
    public boolean isClass(DataSourceV2Relation relation) {
        return relation.table().name().contains("com.azure.cosmos.spark.items.");
    }

    @Override
    public DatasetIdentifier getDatasetIdentifier(DataSourceV2Relation relation) {
        String namespace;
        String name;
        int expectedParts;
        String relationName = relation.table().name().replace("com.azure.cosmos.spark.items.", "");
        String[] tableParts = relationName.split("\\.", expectedParts = 3);
        if (tableParts.length != expectedParts) {
            name = relationName;
            namespace = "azurecosmos";
        } else {
            namespace = String.format("azurecosmos://%s.documents.azure.com/dbs/%s", tableParts[0], tableParts[1]);
            name = String.format("/colls/%s", tableParts[2]);
        }
        return new DatasetIdentifier(name, namespace);
    }

    @Override
    public String getName() {
        return "cosmos";
    }
}

