/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark3.agent.lifecycle.plan.column;

import io.openlineage.client.OpenLineage;
import io.openlineage.spark.agent.lifecycle.plan.column.ColumnLevelLineageBuilder;
import io.openlineage.spark.agent.lifecycle.plan.column.ColumnLevelLineageContext;
import io.openlineage.spark.agent.util.ScalaConversionUtils;
import io.openlineage.spark.api.OpenLineageContext;
import io.openlineage.spark3.agent.lifecycle.plan.column.ExpressionDependencyCollector;
import io.openlineage.spark3.agent.lifecycle.plan.column.InputFieldsCollector;
import io.openlineage.spark3.agent.lifecycle.plan.column.OutputFieldsCollector;
import io.openlineage.spark3.agent.utils.PlanUtils3;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.columnar.InMemoryRelation;
import org.apache.spark.sql.execution.datasources.SaveIntoDataSourceCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.runtime.BoxedUnit;

public class ColumnLevelLineageUtils {
    private static final Logger log = LoggerFactory.getLogger(ColumnLevelLineageUtils.class);

    public static Optional<OpenLineage.ColumnLineageDatasetFacet> buildColumnLineageDatasetFacet(SparkListenerEvent event, OpenLineageContext olContext, OpenLineage.SchemaDatasetFacet schemaFacet) {
        if (!olContext.getQueryExecution().isPresent() || olContext.getQueryExecution().get().optimizedPlan() == null || schemaFacet == null) {
            return Optional.empty();
        }
        ColumnLevelLineageContext context = new ColumnLevelLineageContext(event, olContext, new ColumnLevelLineageBuilder(schemaFacet, olContext));
        LogicalPlan plan = ColumnLevelLineageUtils.getAdjustedPlan(olContext);
        OutputFieldsCollector.collect(context, plan);
        ColumnLevelLineageUtils.collectInputsAndExpressionDependencies(context, plan);
        OpenLineage.ColumnLineageDatasetFacetBuilder facetBuilder = olContext.getOpenLineage().newColumnLineageDatasetFacetBuilder();
        facetBuilder.fields(context.getBuilder().build());
        OpenLineage.ColumnLineageDatasetFacet facet = facetBuilder.build();
        if (facet.getFields().getAdditionalProperties().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(facet);
    }

    private static LogicalPlan getAdjustedPlan(OpenLineageContext context) {
        LogicalPlan logicalPlan = context.getQueryExecution().get().optimizedPlan();
        LogicalPlan plan = logicalPlan instanceof SaveIntoDataSourceCommand ? ((SaveIntoDataSourceCommand)logicalPlan).query() : logicalPlan;
        return plan;
    }

    private static void collectInputsAndExpressionDependencies(ColumnLevelLineageContext context, LogicalPlan plan) {
        ExpressionDependencyCollector.collect(context, plan);
        InputFieldsCollector.collect(context, plan);
        if (plan.children() != null) {
            plan.foreach(node -> {
                if (node instanceof InMemoryRelation) {
                    PlanUtils3.getLogicalPlanOf(context.getOlContext(), (InMemoryRelation)node).ifPresent(cachedPlan -> {
                        ColumnLevelLineageUtils.collectInputsAndExpressionDependencies(context, cachedPlan);
                        Map<String, ExprId> idMap = ScalaConversionUtils.fromSeq(node.output()).stream().collect(Collectors.toMap(NamedExpression::name, NamedExpression::exprId));
                        OutputFieldsCollector.getOutputExpressionsFromTree(cachedPlan).stream().filter(namedExpression -> idMap.containsKey(namedExpression.name())).forEach(namedExpression -> context.getBuilder().addDependency(namedExpression.exprId(), (ExprId)idMap.get(namedExpression.name())));
                    });
                }
                return BoxedUnit.UNIT;
            });
        }
    }
}

