/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark3.agent.lifecycle.plan.column;

import io.openlineage.spark.agent.lifecycle.plan.column.ColumnLevelLineageContext;
import io.openlineage.spark.agent.lifecycle.plan.column.ColumnLevelLineageVisitor;
import io.openlineage.spark.agent.lifecycle.plan.column.CustomColumnLineageVisitor;
import io.openlineage.spark.api.OpenLineageContext;
import java.util.ServiceLoader;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomCollectorsUtils {
    private static final Logger log = LoggerFactory.getLogger(CustomCollectorsUtils.class);

    private static Stream<ColumnLevelLineageVisitor> loadCollectors(OpenLineageContext context) {
        ServiceLoader<CustomColumnLineageVisitor> loader = ServiceLoader.load(CustomColumnLineageVisitor.class);
        return Stream.concat(StreamSupport.stream(Spliterators.spliteratorUnknownSize(loader.iterator(), 0), false).map(customVisitor -> new ColumnLevelLineageVisitor((CustomColumnLineageVisitor)customVisitor){
            final /* synthetic */ CustomColumnLineageVisitor val$customVisitor;
            {
                this.val$customVisitor = customColumnLineageVisitor;
            }

            @Override
            public void collectInputs(ColumnLevelLineageContext context, LogicalPlan node) {
                this.val$customVisitor.collectInputs(node, context.getBuilder());
            }

            @Override
            public void collectOutputs(ColumnLevelLineageContext context, LogicalPlan node) {
                this.val$customVisitor.collectOutputs(node, context.getBuilder());
            }

            @Override
            public void collectExpressionDependencies(ColumnLevelLineageContext context, LogicalPlan node) {
                this.val$customVisitor.collectExpressionDependencies(node, context.getBuilder());
            }
        }), context.getColumnLevelLineageVisitors().stream());
    }

    static void collectInputs(ColumnLevelLineageContext context, LogicalPlan plan) {
        CustomCollectorsUtils.loadCollectors(context.getOlContext()).forEach(collector -> collector.collectInputs(context, plan));
    }

    static void collectOutputs(ColumnLevelLineageContext context, LogicalPlan plan) {
        CustomCollectorsUtils.loadCollectors(context.getOlContext()).forEach(collector -> collector.collectOutputs(context, plan));
    }

    static void collectExpressionDependencies(ColumnLevelLineageContext context, LogicalPlan plan) {
        CustomCollectorsUtils.loadCollectors(context.getOlContext()).forEach(collector -> collector.collectExpressionDependencies(context, plan));
    }
}

