/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark3.agent.lifecycle.plan.column.visitors;

import io.openlineage.spark.agent.lifecycle.plan.column.ColumnLevelLineageBuilder;
import io.openlineage.spark.agent.util.ScalaConversionUtils;
import io.openlineage.spark3.agent.lifecycle.plan.column.ExpressionDependencyCollector;
import io.openlineage.spark3.agent.lifecycle.plan.column.visitors.ExpressionDependencyVisitor;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Union;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnionDependencyVisitor
implements ExpressionDependencyVisitor {
    private static final Logger log = LoggerFactory.getLogger(UnionDependencyVisitor.class);

    @Override
    public boolean isDefinedAt(LogicalPlan plan) {
        return plan instanceof Union;
    }

    @Override
    public void apply(LogicalPlan plan, ColumnLevelLineageBuilder builder) {
        Union union = (Union)plan;
        List children = ScalaConversionUtils.fromSeq(union.children());
        LinkedList childrenAttributes = new LinkedList();
        children.stream().map(child -> ScalaConversionUtils.fromSeq(child.output())).forEach(list -> childrenAttributes.add(new ArrayList(list)));
        int maxAttributeSize = childrenAttributes.stream().map(list -> list.size()).max(Integer::compare).get();
        IntStream.range(0, maxAttributeSize).forEach(position -> {
            ExprId firstExpr = ((Attribute)((ArrayList)childrenAttributes.get(0)).get(position)).exprId();
            IntStream.range(1, children.size()).mapToObj(childIndex -> (Attribute)((ArrayList)childrenAttributes.get(childIndex)).get(position)).forEach(attr -> ExpressionDependencyCollector.traverseExpression((Expression)attr, firstExpr, builder));
        });
    }
}

