/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark34.agent.lifecycle.plan.column;

import io.openlineage.spark.agent.lifecycle.plan.column.ColumnLevelLineageContext;
import io.openlineage.spark.agent.lifecycle.plan.column.ColumnLevelLineageVisitor;
import io.openlineage.spark.agent.util.ReflectionUtils;
import io.openlineage.spark.agent.util.ScalaConversionUtils;
import io.openlineage.spark.api.OpenLineageContext;
import io.openlineage.spark.shaded.org.apache.commons.lang3.reflect.MethodUtils;
import io.openlineage.spark3.agent.lifecycle.plan.column.InputFieldsCollector;
import io.openlineage.spark3.agent.lifecycle.plan.column.OutputFieldsCollector;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.logical.DeltaMergeAction;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;

public class MergeIntoCommandEdgeColumnLineageBuilder
implements ColumnLevelLineageVisitor {
    private static final Logger log = LoggerFactory.getLogger(MergeIntoCommandEdgeColumnLineageBuilder.class);
    protected OpenLineageContext context;
    private static String CLASS = "sql.transaction.tahoe.commands.MergeIntoCommandEdge";

    public static boolean hasClasses() {
        return ReflectionUtils.hasClasses("com.databricks.sql.transaction.tahoe.commands.MergeIntoCommandEdge", "org.apache.spark.sql.catalyst.plans.logical.DeltaMergeIntoNotMatchedClause");
    }

    public MergeIntoCommandEdgeColumnLineageBuilder(OpenLineageContext context) {
        this.context = context;
    }

    @Override
    public void collectInputs(ColumnLevelLineageContext context, LogicalPlan node) {
        if (!node.getClass().getCanonicalName().endsWith(CLASS)) {
            return;
        }
        this.getFieldFromNode(node, "target").ifPresent(target -> InputFieldsCollector.collect(context, target));
        List mergeActionsExprIds = this.getMergeActions(node).filter(action -> action instanceof DeltaMergeAction).map(action -> (DeltaMergeAction)action).filter(action -> action.child() instanceof AttributeReference).filter(action -> context.getBuilder().getOutputExprIdByFieldName(action.targetColNameParts().mkString()).isPresent()).map(action -> ((AttributeReference)action.child()).exprId()).collect(Collectors.toList());
        List<ExprId> inputsToRemove = context.getBuilder().getInputs().keySet().stream().filter(id -> !mergeActionsExprIds.contains(id)).collect(Collectors.toList());
        inputsToRemove.forEach(id -> context.getBuilder().getInputs().remove(id));
        this.getFieldFromNode(node, "source").ifPresent(source -> InputFieldsCollector.collect(context, source));
    }

    @Override
    public void collectOutputs(ColumnLevelLineageContext context, LogicalPlan node) {
        if (!node.getClass().getCanonicalName().endsWith(CLASS)) {
            return;
        }
        this.getFieldFromNode(node, "target").ifPresent(target -> OutputFieldsCollector.collect(context, target));
    }

    @Override
    public void collectExpressionDependencies(ColumnLevelLineageContext context, LogicalPlan node) {
        if (!node.getClass().getCanonicalName().endsWith(CLASS)) {
            return;
        }
        this.getMergeActions(node).filter(action -> action instanceof DeltaMergeAction).map(action -> (DeltaMergeAction)action).filter(action -> action.child() instanceof AttributeReference).filter(action -> context.getBuilder().getOutputExprIdByFieldName(action.targetColNameParts().mkString()).isPresent()).forEach(action -> context.getBuilder().addDependency(context.getBuilder().getOutputExprIdByFieldName(action.targetColNameParts().mkString()).get(), ((AttributeReference)action.child()).exprId()));
    }

    public Stream<Expression> getMergeActions(LogicalPlan node) {
        Optional<ArrayBuffer> matchedClauses = this.getFieldFromNode(node, "matchedClauses");
        Optional<ArrayBuffer> notMatchedClauses = this.getFieldFromNode(node, "notMatchedClauses");
        return Stream.concat(ScalaConversionUtils.fromSeq((Seq)matchedClauses.orElse(new ArrayBuffer())).stream().flatMap(clause -> ScalaConversionUtils.fromSeq(clause.actions()).stream()), ScalaConversionUtils.fromSeq((Seq)notMatchedClauses.orElse(new ArrayBuffer())).stream().flatMap(clause -> ScalaConversionUtils.fromSeq(clause.actions()).stream()));
    }

    private <T> Optional<T> getFieldFromNode(LogicalPlan node, String field) {
        try {
            return Optional.of(MethodUtils.invokeMethod(node, field));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.warn("Couldn't extract field {} from {}", (Object)field, (Object)node);
            return Optional.empty();
        }
    }
}

