/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client.transports;

import io.openlineage.client.OpenLineage;
import io.openlineage.client.OpenLineageClientUtils;
import io.openlineage.client.transports.KafkaConfig;
import io.openlineage.client.transports.Transport;
import lombok.NonNull;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KafkaTransport
extends Transport {
    private static final Logger log = LoggerFactory.getLogger(KafkaTransport.class);
    private final String topicName;
    private final String messageKey;
    private final KafkaProducer<String, String> producer;

    public KafkaTransport(@NonNull KafkaConfig kafkaConfig) {
        this((KafkaProducer<String, String>)new KafkaProducer(kafkaConfig.getProperties()), kafkaConfig);
        if (kafkaConfig == null) {
            throw new NullPointerException("kafkaConfig is marked non-null but is null");
        }
    }

    public KafkaTransport(@NonNull KafkaProducer<String, String> kafkaProducer, @NonNull KafkaConfig kafkaConfig) {
        super(Transport.Type.KAFKA);
        if (kafkaProducer == null) {
            throw new NullPointerException("kafkaProducer is marked non-null but is null");
        }
        if (kafkaConfig == null) {
            throw new NullPointerException("kafkaConfig is marked non-null but is null");
        }
        this.topicName = kafkaConfig.getTopicName();
        this.messageKey = kafkaConfig.getMessageKey();
        this.producer = kafkaProducer;
    }

    private String getMessageKey(@NonNull OpenLineage.RunEvent runEvent) {
        OpenLineage.ParentRunFacet parentRunFacet;
        if (runEvent == null) {
            throw new NullPointerException("runEvent is marked non-null but is null");
        }
        OpenLineage.Run run = runEvent.getRun();
        OpenLineage.Job job = runEvent.getJob();
        if (run == null || job == null) {
            return null;
        }
        OpenLineage.RunFacets runFacets = run.getFacets();
        if (runFacets != null && (parentRunFacet = runFacets.getParent()) != null) {
            OpenLineage.ParentRunFacetJob parentJob = parentRunFacet.getJob();
            OpenLineage.ParentRunFacetRun parentRun = parentRunFacet.getRun();
            if (parentRun != null && parentJob != null) {
                return "run:" + parentJob.getNamespace() + "/" + parentJob.getName();
            }
        }
        return "run:" + job.getNamespace() + "/" + job.getName();
    }

    private String getMessageKey(@NonNull OpenLineage.DatasetEvent datasetEvent) {
        if (datasetEvent == null) {
            throw new NullPointerException("datasetEvent is marked non-null but is null");
        }
        OpenLineage.StaticDataset dataset = datasetEvent.getDataset();
        if (dataset == null) {
            return null;
        }
        return "dataset:" + dataset.getNamespace() + "/" + dataset.getName();
    }

    private String getMessageKey(@NonNull OpenLineage.JobEvent jobEvent) {
        if (jobEvent == null) {
            throw new NullPointerException("jobEvent is marked non-null but is null");
        }
        OpenLineage.Job job = jobEvent.getJob();
        if (job == null) {
            return null;
        }
        return "job:" + job.getNamespace() + "/" + job.getName();
    }

    @Override
    public void emit(@NonNull OpenLineage.RunEvent runEvent) {
        if (runEvent == null) {
            throw new NullPointerException("runEvent is marked non-null but is null");
        }
        this.emit(OpenLineageClientUtils.toJson(runEvent), this.getMessageKey(runEvent));
    }

    @Override
    public void emit(@NonNull OpenLineage.DatasetEvent datasetEvent) {
        if (datasetEvent == null) {
            throw new NullPointerException("datasetEvent is marked non-null but is null");
        }
        this.emit(OpenLineageClientUtils.toJson(datasetEvent), this.getMessageKey(datasetEvent));
    }

    @Override
    public void emit(@NonNull OpenLineage.JobEvent jobEvent) {
        if (jobEvent == null) {
            throw new NullPointerException("jobEvent is marked non-null but is null");
        }
        this.emit(OpenLineageClientUtils.toJson(jobEvent), this.getMessageKey(jobEvent));
    }

    private void emit(String eventAsJson, String eventKey) {
        String partitionKey = this.messageKey;
        if (partitionKey == null) {
            partitionKey = eventKey;
        }
        ProducerRecord record = new ProducerRecord(this.topicName, (Object)partitionKey, (Object)eventAsJson);
        try {
            this.producer.send(record);
        }
        catch (Exception e) {
            log.error("Failed to collect lineage event: {}", (Object)eventAsJson, (Object)e);
        }
    }
}

