/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.facets;

import io.micrometer.core.instrument.Tag;
import io.openlineage.client.OpenLineage;
import io.openlineage.spark.agent.Versions;
import io.openlineage.spark.api.SparkOpenLineageConfig;
import io.openlineage.spark.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;

public class DebugRunFacet
extends OpenLineage.DefaultRunFacet {
    private final ClasspathDebugFacet classpath;
    private final SystemDebugFacet system;
    private final SparkConfigDebugFacet config;
    private final LogicalPlanDebugFacet logicalPlan;
    private final MetricsDebugFacet metrics;

    public DebugRunFacet(SparkConfigDebugFacet config, ClasspathDebugFacet classpath, SystemDebugFacet system, LogicalPlanDebugFacet logicalPlan, MetricsDebugFacet metricsDebugFacet) {
        super(Versions.OPEN_LINEAGE_PRODUCER_URI);
        this.config = config;
        this.classpath = classpath;
        this.system = system;
        this.logicalPlan = logicalPlan;
        this.metrics = metricsDebugFacet;
    }

    public ClasspathDebugFacet getClasspath() {
        return this.classpath;
    }

    public SystemDebugFacet getSystem() {
        return this.system;
    }

    public SparkConfigDebugFacet getConfig() {
        return this.config;
    }

    public LogicalPlanDebugFacet getLogicalPlan() {
        return this.logicalPlan;
    }

    public MetricsDebugFacet getMetrics() {
        return this.metrics;
    }

    public static final class MetricsNode {
        private final String name;
        private final double value;
        private final List<Tag> tags;

        MetricsNode(String name, double value, List<Tag> tags) {
            this.name = name;
            this.value = value;
            this.tags = tags;
        }

        public static MetricsNodeBuilder builder() {
            return new MetricsNodeBuilder();
        }

        public String getName() {
            return this.name;
        }

        public double getValue() {
            return this.value;
        }

        public List<Tag> getTags() {
            return this.tags;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MetricsNode)) {
                return false;
            }
            MetricsNode other = (MetricsNode)o;
            if (Double.compare(this.getValue(), other.getValue()) != 0) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            List<Tag> this$tags = this.getTags();
            List<Tag> other$tags = other.getTags();
            return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $value = Double.doubleToLongBits(this.getValue());
            result = result * 59 + (int)($value >>> 32 ^ $value);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            List<Tag> $tags = this.getTags();
            result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
            return result;
        }

        public String toString() {
            return "DebugRunFacet.MetricsNode(name=" + this.getName() + ", value=" + this.getValue() + ", tags=" + this.getTags() + ")";
        }

        public static class MetricsNodeBuilder {
            private String name;
            private double value;
            private List<Tag> tags;

            MetricsNodeBuilder() {
            }

            public MetricsNodeBuilder name(String name) {
                this.name = name;
                return this;
            }

            public MetricsNodeBuilder value(double value) {
                this.value = value;
                return this;
            }

            public MetricsNodeBuilder tags(List<Tag> tags) {
                this.tags = tags;
                return this;
            }

            public MetricsNode build() {
                return new MetricsNode(this.name, this.value, this.tags);
            }

            public String toString() {
                return "DebugRunFacet.MetricsNode.MetricsNodeBuilder(name=" + this.name + ", value=" + this.value + ", tags=" + this.tags + ")";
            }
        }
    }

    public static final class MetricsDebugFacet {
        private final List<MetricsNode> metrics;

        public MetricsDebugFacet(List<MetricsNode> metrics) {
            this.metrics = metrics;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MetricsDebugFacet)) {
                return false;
            }
            MetricsDebugFacet other = (MetricsDebugFacet)o;
            List<MetricsNode> this$metrics = this.getMetrics();
            List<MetricsNode> other$metrics = other.getMetrics();
            return !(this$metrics == null ? other$metrics != null : !((Object)this$metrics).equals(other$metrics));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<MetricsNode> $metrics = this.getMetrics();
            result = result * 59 + ($metrics == null ? 43 : ((Object)$metrics).hashCode());
            return result;
        }

        public String toString() {
            return "DebugRunFacet.MetricsDebugFacet(metrics=" + this.getMetrics() + ")";
        }

        public List<MetricsNode> getMetrics() {
            return this.metrics;
        }
    }

    public static final class LogicalPlanNode {
        private final String id;
        private final String desc;
        private final List<String> children;

        LogicalPlanNode(String id, String desc, List<String> children) {
            this.id = id;
            this.desc = desc;
            this.children = children;
        }

        public static LogicalPlanNodeBuilder builder() {
            return new LogicalPlanNodeBuilder();
        }

        public String getId() {
            return this.id;
        }

        public String getDesc() {
            return this.desc;
        }

        public List<String> getChildren() {
            return this.children;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LogicalPlanNode)) {
                return false;
            }
            LogicalPlanNode other = (LogicalPlanNode)o;
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$desc = this.getDesc();
            String other$desc = other.getDesc();
            if (this$desc == null ? other$desc != null : !this$desc.equals(other$desc)) {
                return false;
            }
            List<String> this$children = this.getChildren();
            List<String> other$children = other.getChildren();
            return !(this$children == null ? other$children != null : !((Object)this$children).equals(other$children));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $desc = this.getDesc();
            result = result * 59 + ($desc == null ? 43 : $desc.hashCode());
            List<String> $children = this.getChildren();
            result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
            return result;
        }

        public String toString() {
            return "DebugRunFacet.LogicalPlanNode(id=" + this.getId() + ", desc=" + this.getDesc() + ", children=" + this.getChildren() + ")";
        }

        public static class LogicalPlanNodeBuilder {
            private String id;
            private String desc;
            private List<String> children;

            LogicalPlanNodeBuilder() {
            }

            public LogicalPlanNodeBuilder id(String id) {
                this.id = id;
                return this;
            }

            public LogicalPlanNodeBuilder desc(String desc) {
                this.desc = desc;
                return this;
            }

            public LogicalPlanNodeBuilder children(List<String> children) {
                this.children = children;
                return this;
            }

            public LogicalPlanNode build() {
                return new LogicalPlanNode(this.id, this.desc, this.children);
            }

            public String toString() {
                return "DebugRunFacet.LogicalPlanNode.LogicalPlanNodeBuilder(id=" + this.id + ", desc=" + this.desc + ", children=" + this.children + ")";
            }
        }
    }

    public static final class LogicalPlanDebugFacet {
        private final List<LogicalPlanNode> nodes;

        public LogicalPlanDebugFacet(List<LogicalPlanNode> nodes) {
            this.nodes = nodes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LogicalPlanDebugFacet)) {
                return false;
            }
            LogicalPlanDebugFacet other = (LogicalPlanDebugFacet)o;
            List<LogicalPlanNode> this$nodes = this.getNodes();
            List<LogicalPlanNode> other$nodes = other.getNodes();
            return !(this$nodes == null ? other$nodes != null : !((Object)this$nodes).equals(other$nodes));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<LogicalPlanNode> $nodes = this.getNodes();
            result = result * 59 + ($nodes == null ? 43 : ((Object)$nodes).hashCode());
            return result;
        }

        public String toString() {
            return "DebugRunFacet.LogicalPlanDebugFacet(nodes=" + this.getNodes() + ")";
        }

        public List<LogicalPlanNode> getNodes() {
            return this.nodes;
        }
    }

    public static final class SystemDebugFacet {
        private final String sparkDeployMode;
        private final String javaVersion;
        private final String javaVendor;
        private final String osArch;
        private final String osName;
        private final String osVersion;
        private final String userLanguage;
        private final String userTimezone;

        SystemDebugFacet(String sparkDeployMode, String javaVersion, String javaVendor, String osArch, String osName, String osVersion, String userLanguage, String userTimezone) {
            this.sparkDeployMode = sparkDeployMode;
            this.javaVersion = javaVersion;
            this.javaVendor = javaVendor;
            this.osArch = osArch;
            this.osName = osName;
            this.osVersion = osVersion;
            this.userLanguage = userLanguage;
            this.userTimezone = userTimezone;
        }

        public static SystemDebugFacetBuilder builder() {
            return new SystemDebugFacetBuilder();
        }

        public String getSparkDeployMode() {
            return this.sparkDeployMode;
        }

        public String getJavaVersion() {
            return this.javaVersion;
        }

        public String getJavaVendor() {
            return this.javaVendor;
        }

        public String getOsArch() {
            return this.osArch;
        }

        public String getOsName() {
            return this.osName;
        }

        public String getOsVersion() {
            return this.osVersion;
        }

        public String getUserLanguage() {
            return this.userLanguage;
        }

        public String getUserTimezone() {
            return this.userTimezone;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SystemDebugFacet)) {
                return false;
            }
            SystemDebugFacet other = (SystemDebugFacet)o;
            String this$sparkDeployMode = this.getSparkDeployMode();
            String other$sparkDeployMode = other.getSparkDeployMode();
            if (this$sparkDeployMode == null ? other$sparkDeployMode != null : !this$sparkDeployMode.equals(other$sparkDeployMode)) {
                return false;
            }
            String this$javaVersion = this.getJavaVersion();
            String other$javaVersion = other.getJavaVersion();
            if (this$javaVersion == null ? other$javaVersion != null : !this$javaVersion.equals(other$javaVersion)) {
                return false;
            }
            String this$javaVendor = this.getJavaVendor();
            String other$javaVendor = other.getJavaVendor();
            if (this$javaVendor == null ? other$javaVendor != null : !this$javaVendor.equals(other$javaVendor)) {
                return false;
            }
            String this$osArch = this.getOsArch();
            String other$osArch = other.getOsArch();
            if (this$osArch == null ? other$osArch != null : !this$osArch.equals(other$osArch)) {
                return false;
            }
            String this$osName = this.getOsName();
            String other$osName = other.getOsName();
            if (this$osName == null ? other$osName != null : !this$osName.equals(other$osName)) {
                return false;
            }
            String this$osVersion = this.getOsVersion();
            String other$osVersion = other.getOsVersion();
            if (this$osVersion == null ? other$osVersion != null : !this$osVersion.equals(other$osVersion)) {
                return false;
            }
            String this$userLanguage = this.getUserLanguage();
            String other$userLanguage = other.getUserLanguage();
            if (this$userLanguage == null ? other$userLanguage != null : !this$userLanguage.equals(other$userLanguage)) {
                return false;
            }
            String this$userTimezone = this.getUserTimezone();
            String other$userTimezone = other.getUserTimezone();
            return !(this$userTimezone == null ? other$userTimezone != null : !this$userTimezone.equals(other$userTimezone));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $sparkDeployMode = this.getSparkDeployMode();
            result = result * 59 + ($sparkDeployMode == null ? 43 : $sparkDeployMode.hashCode());
            String $javaVersion = this.getJavaVersion();
            result = result * 59 + ($javaVersion == null ? 43 : $javaVersion.hashCode());
            String $javaVendor = this.getJavaVendor();
            result = result * 59 + ($javaVendor == null ? 43 : $javaVendor.hashCode());
            String $osArch = this.getOsArch();
            result = result * 59 + ($osArch == null ? 43 : $osArch.hashCode());
            String $osName = this.getOsName();
            result = result * 59 + ($osName == null ? 43 : $osName.hashCode());
            String $osVersion = this.getOsVersion();
            result = result * 59 + ($osVersion == null ? 43 : $osVersion.hashCode());
            String $userLanguage = this.getUserLanguage();
            result = result * 59 + ($userLanguage == null ? 43 : $userLanguage.hashCode());
            String $userTimezone = this.getUserTimezone();
            result = result * 59 + ($userTimezone == null ? 43 : $userTimezone.hashCode());
            return result;
        }

        public String toString() {
            return "DebugRunFacet.SystemDebugFacet(sparkDeployMode=" + this.getSparkDeployMode() + ", javaVersion=" + this.getJavaVersion() + ", javaVendor=" + this.getJavaVendor() + ", osArch=" + this.getOsArch() + ", osName=" + this.getOsName() + ", osVersion=" + this.getOsVersion() + ", userLanguage=" + this.getUserLanguage() + ", userTimezone=" + this.getUserTimezone() + ")";
        }

        public static class SystemDebugFacetBuilder {
            private String sparkDeployMode;
            private String javaVersion;
            private String javaVendor;
            private String osArch;
            private String osName;
            private String osVersion;
            private String userLanguage;
            private String userTimezone;

            SystemDebugFacetBuilder() {
            }

            public SystemDebugFacetBuilder sparkDeployMode(String sparkDeployMode) {
                this.sparkDeployMode = sparkDeployMode;
                return this;
            }

            public SystemDebugFacetBuilder javaVersion(String javaVersion) {
                this.javaVersion = javaVersion;
                return this;
            }

            public SystemDebugFacetBuilder javaVendor(String javaVendor) {
                this.javaVendor = javaVendor;
                return this;
            }

            public SystemDebugFacetBuilder osArch(String osArch) {
                this.osArch = osArch;
                return this;
            }

            public SystemDebugFacetBuilder osName(String osName) {
                this.osName = osName;
                return this;
            }

            public SystemDebugFacetBuilder osVersion(String osVersion) {
                this.osVersion = osVersion;
                return this;
            }

            public SystemDebugFacetBuilder userLanguage(String userLanguage) {
                this.userLanguage = userLanguage;
                return this;
            }

            public SystemDebugFacetBuilder userTimezone(String userTimezone) {
                this.userTimezone = userTimezone;
                return this;
            }

            public SystemDebugFacet build() {
                return new SystemDebugFacet(this.sparkDeployMode, this.javaVersion, this.javaVendor, this.osArch, this.osName, this.osVersion, this.userLanguage, this.userTimezone);
            }

            public String toString() {
                return "DebugRunFacet.SystemDebugFacet.SystemDebugFacetBuilder(sparkDeployMode=" + this.sparkDeployMode + ", javaVersion=" + this.javaVersion + ", javaVendor=" + this.javaVendor + ", osArch=" + this.osArch + ", osName=" + this.osName + ", osVersion=" + this.osVersion + ", userLanguage=" + this.userLanguage + ", userTimezone=" + this.userTimezone + ")";
            }
        }
    }

    public static final class ClasspathDebugClassDetails {
        private final String className;
        private final boolean isOnClasspath;
        private final String packageVersion;

        ClasspathDebugClassDetails(String className, boolean isOnClasspath, String packageVersion) {
            this.className = className;
            this.isOnClasspath = isOnClasspath;
            this.packageVersion = packageVersion;
        }

        public static ClasspathDebugClassDetailsBuilder builder() {
            return new ClasspathDebugClassDetailsBuilder();
        }

        public String getClassName() {
            return this.className;
        }

        public boolean isOnClasspath() {
            return this.isOnClasspath;
        }

        public String getPackageVersion() {
            return this.packageVersion;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClasspathDebugClassDetails)) {
                return false;
            }
            ClasspathDebugClassDetails other = (ClasspathDebugClassDetails)o;
            if (this.isOnClasspath() != other.isOnClasspath()) {
                return false;
            }
            String this$className = this.getClassName();
            String other$className = other.getClassName();
            if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
                return false;
            }
            String this$packageVersion = this.getPackageVersion();
            String other$packageVersion = other.getPackageVersion();
            return !(this$packageVersion == null ? other$packageVersion != null : !this$packageVersion.equals(other$packageVersion));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isOnClasspath() ? 79 : 97);
            String $className = this.getClassName();
            result = result * 59 + ($className == null ? 43 : $className.hashCode());
            String $packageVersion = this.getPackageVersion();
            result = result * 59 + ($packageVersion == null ? 43 : $packageVersion.hashCode());
            return result;
        }

        public String toString() {
            return "DebugRunFacet.ClasspathDebugClassDetails(className=" + this.getClassName() + ", isOnClasspath=" + this.isOnClasspath() + ", packageVersion=" + this.getPackageVersion() + ")";
        }

        public static class ClasspathDebugClassDetailsBuilder {
            private String className;
            private boolean isOnClasspath;
            private String packageVersion;

            ClasspathDebugClassDetailsBuilder() {
            }

            public ClasspathDebugClassDetailsBuilder className(String className) {
                this.className = className;
                return this;
            }

            public ClasspathDebugClassDetailsBuilder isOnClasspath(boolean isOnClasspath) {
                this.isOnClasspath = isOnClasspath;
                return this;
            }

            public ClasspathDebugClassDetailsBuilder packageVersion(String packageVersion) {
                this.packageVersion = packageVersion;
                return this;
            }

            public ClasspathDebugClassDetails build() {
                return new ClasspathDebugClassDetails(this.className, this.isOnClasspath, this.packageVersion);
            }

            public String toString() {
                return "DebugRunFacet.ClasspathDebugClassDetails.ClasspathDebugClassDetailsBuilder(className=" + this.className + ", isOnClasspath=" + this.isOnClasspath + ", packageVersion=" + this.packageVersion + ")";
            }
        }
    }

    public static final class ClasspathDebugFacet {
        private final String openLineageVersion;
        private final String sparkVersion;
        private final String scalaVersion;
        private final List<String> jars;
        private final List<ClasspathDebugClassDetails> classDetails;

        ClasspathDebugFacet(String openLineageVersion, String sparkVersion, String scalaVersion, List<String> jars, List<ClasspathDebugClassDetails> classDetails) {
            this.openLineageVersion = openLineageVersion;
            this.sparkVersion = sparkVersion;
            this.scalaVersion = scalaVersion;
            this.jars = jars;
            this.classDetails = classDetails;
        }

        public static ClasspathDebugFacetBuilder builder() {
            return new ClasspathDebugFacetBuilder();
        }

        public String getOpenLineageVersion() {
            return this.openLineageVersion;
        }

        public String getSparkVersion() {
            return this.sparkVersion;
        }

        public String getScalaVersion() {
            return this.scalaVersion;
        }

        public List<String> getJars() {
            return this.jars;
        }

        public List<ClasspathDebugClassDetails> getClassDetails() {
            return this.classDetails;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClasspathDebugFacet)) {
                return false;
            }
            ClasspathDebugFacet other = (ClasspathDebugFacet)o;
            String this$openLineageVersion = this.getOpenLineageVersion();
            String other$openLineageVersion = other.getOpenLineageVersion();
            if (this$openLineageVersion == null ? other$openLineageVersion != null : !this$openLineageVersion.equals(other$openLineageVersion)) {
                return false;
            }
            String this$sparkVersion = this.getSparkVersion();
            String other$sparkVersion = other.getSparkVersion();
            if (this$sparkVersion == null ? other$sparkVersion != null : !this$sparkVersion.equals(other$sparkVersion)) {
                return false;
            }
            String this$scalaVersion = this.getScalaVersion();
            String other$scalaVersion = other.getScalaVersion();
            if (this$scalaVersion == null ? other$scalaVersion != null : !this$scalaVersion.equals(other$scalaVersion)) {
                return false;
            }
            List<String> this$jars = this.getJars();
            List<String> other$jars = other.getJars();
            if (this$jars == null ? other$jars != null : !((Object)this$jars).equals(other$jars)) {
                return false;
            }
            List<ClasspathDebugClassDetails> this$classDetails = this.getClassDetails();
            List<ClasspathDebugClassDetails> other$classDetails = other.getClassDetails();
            return !(this$classDetails == null ? other$classDetails != null : !((Object)this$classDetails).equals(other$classDetails));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $openLineageVersion = this.getOpenLineageVersion();
            result = result * 59 + ($openLineageVersion == null ? 43 : $openLineageVersion.hashCode());
            String $sparkVersion = this.getSparkVersion();
            result = result * 59 + ($sparkVersion == null ? 43 : $sparkVersion.hashCode());
            String $scalaVersion = this.getScalaVersion();
            result = result * 59 + ($scalaVersion == null ? 43 : $scalaVersion.hashCode());
            List<String> $jars = this.getJars();
            result = result * 59 + ($jars == null ? 43 : ((Object)$jars).hashCode());
            List<ClasspathDebugClassDetails> $classDetails = this.getClassDetails();
            result = result * 59 + ($classDetails == null ? 43 : ((Object)$classDetails).hashCode());
            return result;
        }

        public String toString() {
            return "DebugRunFacet.ClasspathDebugFacet(openLineageVersion=" + this.getOpenLineageVersion() + ", sparkVersion=" + this.getSparkVersion() + ", scalaVersion=" + this.getScalaVersion() + ", jars=" + this.getJars() + ", classDetails=" + this.getClassDetails() + ")";
        }

        public static class ClasspathDebugFacetBuilder {
            private String openLineageVersion;
            private String sparkVersion;
            private String scalaVersion;
            private List<String> jars;
            private List<ClasspathDebugClassDetails> classDetails;

            ClasspathDebugFacetBuilder() {
            }

            public ClasspathDebugFacetBuilder openLineageVersion(String openLineageVersion) {
                this.openLineageVersion = openLineageVersion;
                return this;
            }

            public ClasspathDebugFacetBuilder sparkVersion(String sparkVersion) {
                this.sparkVersion = sparkVersion;
                return this;
            }

            public ClasspathDebugFacetBuilder scalaVersion(String scalaVersion) {
                this.scalaVersion = scalaVersion;
                return this;
            }

            public ClasspathDebugFacetBuilder jars(List<String> jars) {
                this.jars = jars;
                return this;
            }

            public ClasspathDebugFacetBuilder classDetails(List<ClasspathDebugClassDetails> classDetails) {
                this.classDetails = classDetails;
                return this;
            }

            public ClasspathDebugFacet build() {
                return new ClasspathDebugFacet(this.openLineageVersion, this.sparkVersion, this.scalaVersion, this.jars, this.classDetails);
            }

            public String toString() {
                return "DebugRunFacet.ClasspathDebugFacet.ClasspathDebugFacetBuilder(openLineageVersion=" + this.openLineageVersion + ", sparkVersion=" + this.sparkVersion + ", scalaVersion=" + this.scalaVersion + ", jars=" + this.jars + ", classDetails=" + this.classDetails + ")";
            }
        }
    }

    @JsonDeserialize(builder=SparkConfigDebugFacetBuilder.class)
    public static final class SparkConfigDebugFacet {
        private final String extraListeners;
        private final SparkOpenLineageConfig openLineageConfig;
        private final String catalogClass;
        private final String extensions;

        public static SparkConfigDebugFacetBuilder builder() {
            return new SparkConfigDebugFacetBuilder();
        }

        public String getExtraListeners() {
            return this.extraListeners;
        }

        public SparkOpenLineageConfig getOpenLineageConfig() {
            return this.openLineageConfig;
        }

        public String getCatalogClass() {
            return this.catalogClass;
        }

        public String getExtensions() {
            return this.extensions;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SparkConfigDebugFacet)) {
                return false;
            }
            SparkConfigDebugFacet other = (SparkConfigDebugFacet)o;
            String this$extraListeners = this.getExtraListeners();
            String other$extraListeners = other.getExtraListeners();
            if (this$extraListeners == null ? other$extraListeners != null : !this$extraListeners.equals(other$extraListeners)) {
                return false;
            }
            SparkOpenLineageConfig this$openLineageConfig = this.getOpenLineageConfig();
            SparkOpenLineageConfig other$openLineageConfig = other.getOpenLineageConfig();
            if (this$openLineageConfig == null ? other$openLineageConfig != null : !this$openLineageConfig.equals(other$openLineageConfig)) {
                return false;
            }
            String this$catalogClass = this.getCatalogClass();
            String other$catalogClass = other.getCatalogClass();
            if (this$catalogClass == null ? other$catalogClass != null : !this$catalogClass.equals(other$catalogClass)) {
                return false;
            }
            String this$extensions = this.getExtensions();
            String other$extensions = other.getExtensions();
            return !(this$extensions == null ? other$extensions != null : !this$extensions.equals(other$extensions));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $extraListeners = this.getExtraListeners();
            result = result * 59 + ($extraListeners == null ? 43 : $extraListeners.hashCode());
            SparkOpenLineageConfig $openLineageConfig = this.getOpenLineageConfig();
            result = result * 59 + ($openLineageConfig == null ? 43 : $openLineageConfig.hashCode());
            String $catalogClass = this.getCatalogClass();
            result = result * 59 + ($catalogClass == null ? 43 : $catalogClass.hashCode());
            String $extensions = this.getExtensions();
            result = result * 59 + ($extensions == null ? 43 : $extensions.hashCode());
            return result;
        }

        public String toString() {
            return "DebugRunFacet.SparkConfigDebugFacet(extraListeners=" + this.getExtraListeners() + ", openLineageConfig=" + this.getOpenLineageConfig() + ", catalogClass=" + this.getCatalogClass() + ", extensions=" + this.getExtensions() + ")";
        }

        public SparkConfigDebugFacet(String extraListeners, SparkOpenLineageConfig openLineageConfig, String catalogClass, String extensions) {
            this.extraListeners = extraListeners;
            this.openLineageConfig = openLineageConfig;
            this.catalogClass = catalogClass;
            this.extensions = extensions;
        }

        public static class SparkConfigDebugFacetBuilder {
            private String extraListeners;
            private SparkOpenLineageConfig openLineageConfig;
            private String catalogClass;
            private String extensions;

            SparkConfigDebugFacetBuilder() {
            }

            public SparkConfigDebugFacetBuilder extraListeners(String extraListeners) {
                this.extraListeners = extraListeners;
                return this;
            }

            public SparkConfigDebugFacetBuilder openLineageConfig(SparkOpenLineageConfig openLineageConfig) {
                this.openLineageConfig = openLineageConfig;
                return this;
            }

            public SparkConfigDebugFacetBuilder catalogClass(String catalogClass) {
                this.catalogClass = catalogClass;
                return this;
            }

            public SparkConfigDebugFacetBuilder extensions(String extensions) {
                this.extensions = extensions;
                return this;
            }

            public SparkConfigDebugFacet build() {
                return new SparkConfigDebugFacet(this.extraListeners, this.openLineageConfig, this.catalogClass, this.extensions);
            }

            public String toString() {
                return "DebugRunFacet.SparkConfigDebugFacet.SparkConfigDebugFacetBuilder(extraListeners=" + this.extraListeners + ", openLineageConfig=" + this.openLineageConfig + ", catalogClass=" + this.catalogClass + ", extensions=" + this.extensions + ")";
            }
        }
    }
}

