/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.facets;

import io.openlineage.client.OpenLineage;
import io.openlineage.spark.agent.Versions;
import java.io.PrintWriter;
import java.io.StringWriter;
import lombok.NonNull;

public class ErrorFacet
extends OpenLineage.DefaultRunFacet {
    private final Exception exception;

    public ErrorFacet(@NonNull Exception exception) {
        super(Versions.OPEN_LINEAGE_PRODUCER_URI);
        if (exception == null) {
            throw new NullPointerException("exception is marked non-null but is null");
        }
        this.exception = exception;
    }

    public String getMessage() {
        return this.exception.getMessage();
    }

    public String getStackTrace() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.exception.printStackTrace(pw);
        return sw.toString();
    }

    public static ErrorFacetBuilder builder() {
        return new ErrorFacetBuilder();
    }

    public static class ErrorFacetBuilder {
        private Exception exception;

        ErrorFacetBuilder() {
        }

        public ErrorFacetBuilder exception(@NonNull Exception exception) {
            if (exception == null) {
                throw new NullPointerException("exception is marked non-null but is null");
            }
            this.exception = exception;
            return this;
        }

        public ErrorFacet build() {
            return new ErrorFacet(this.exception);
        }

        public String toString() {
            return "ErrorFacet.ErrorFacetBuilder(exception=" + this.exception + ")";
        }
    }
}

