/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.hooks;

import io.openlineage.client.OpenLineage;
import io.openlineage.spark.agent.hooks.RunEventBuilderHook;
import io.openlineage.spark.agent.util.DatabricksUtils;
import io.openlineage.spark.api.OpenLineageContext;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobNameHook
implements RunEventBuilderHook {
    private static final Logger log = LoggerFactory.getLogger(JobNameHook.class);
    private static final String JOB_NAME_PARTS_SEPARATOR = ".";
    private static final String INNER_SEPARATOR = "_";
    private final OpenLineageContext openLineageContext;

    public JobNameHook(OpenLineageContext openLineageContext) {
        this.openLineageContext = openLineageContext;
    }

    @Override
    public void preBuild(OpenLineage.RunEventBuilder runEventBuilder) {
        if (this.openLineageContext != null && this.openLineageContext.getOpenLineageConfig() != null && !this.openLineageContext.getOpenLineageConfig().getJobName().getAppendDatasetName().booleanValue()) {
            return;
        }
        OpenLineage.RunEvent runEvent = runEventBuilder.build();
        OpenLineage.Job job = runEvent.getJob();
        OpenLineage.Job newJob = this.openLineageContext.getOpenLineage().newJobBuilder().facets(job.getFacets()).namespace(job.getNamespace()).name(this.buildJobName(job, runEvent)).build();
        runEventBuilder.job(newJob);
    }

    private String buildJobName(OpenLineage.Job job, OpenLineage.RunEvent runEvent) {
        if (this.openLineageContext.getJobName() != null) {
            return this.openLineageContext.getJobName();
        }
        StringBuilder jobNameBuilder = new StringBuilder();
        if (!DatabricksUtils.isRunOnDatabricksPlatform(this.openLineageContext)) {
            jobNameBuilder.append(job.getName());
        } else {
            jobNameBuilder.append(DatabricksUtils.prettifyDatabricksJobName(this.openLineageContext, job.getName()));
        }
        if (runEvent.getOutputs() != null && runEvent.getOutputs().size() > 0) {
            log.debug("Job name appends following output: {}", (Object)Arrays.toString(runEvent.getOutputs().toArray()));
            jobNameBuilder.append(JOB_NAME_PARTS_SEPARATOR).append(JobNameHook.trimPath(runEvent.getOutputs().get(0).getName()).replace(JOB_NAME_PARTS_SEPARATOR, INNER_SEPARATOR));
        } else {
            log.debug("No outputs - do not append anything to job name.");
        }
        String jobName = jobNameBuilder.toString();
        if (this.openLineageContext != null && this.openLineageContext.getOpenLineageConfig() != null && this.openLineageContext.getOpenLineageConfig().getJobName().getReplaceDotWithUnderscore().booleanValue()) {
            jobName = jobName.replace(JOB_NAME_PARTS_SEPARATOR, INNER_SEPARATOR);
        }
        this.openLineageContext.setJobName(jobName);
        return jobName;
    }

    private static String trimPath(String path) {
        if (path.lastIndexOf("/") > 0) {
            String[] parts = path.split("/");
            if (parts.length >= 2) {
                return parts[parts.length - 2] + INNER_SEPARATOR + parts[parts.length - 1];
            }
            return parts[parts.length - 1];
        }
        return path;
    }
}

