/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.lifecycle;

import io.micrometer.core.instrument.MeterRegistry;
import io.openlineage.client.OpenLineage;
import io.openlineage.spark.agent.EventEmitter;
import io.openlineage.spark.agent.Versions;
import io.openlineage.spark.agent.lifecycle.ExecutionContext;
import io.openlineage.spark.agent.lifecycle.InternalEventHandlerFactory;
import io.openlineage.spark.agent.lifecycle.OpenLineageRunEventBuilder;
import io.openlineage.spark.agent.lifecycle.RddExecutionContext;
import io.openlineage.spark.agent.lifecycle.SparkSQLExecutionContext;
import io.openlineage.spark.api.OpenLineageContext;
import io.openlineage.spark.api.OpenLineageEventHandlerFactory;
import io.openlineage.spark.api.SparkOpenLineageConfig;
import io.openlineage.spark.api.Vendors;
import io.openlineage.spark.shaded.org.apache.commons.lang3.reflect.MethodUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Optional;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.SQLExecution;
import org.apache.spark.sql.execution.ui.SparkListenerSQLExecutionEnd;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextFactory {
    private static final Logger log = LoggerFactory.getLogger(ContextFactory.class);
    public final EventEmitter openLineageEventEmitter;
    private final MeterRegistry meterRegistry;
    private final SparkOpenLineageConfig config;
    private final OpenLineageEventHandlerFactory handlerFactory;

    public ContextFactory(EventEmitter openLineageEventEmitter, MeterRegistry meterRegistry, SparkOpenLineageConfig config) {
        this.openLineageEventEmitter = openLineageEventEmitter;
        this.meterRegistry = meterRegistry;
        this.config = config;
        this.handlerFactory = new InternalEventHandlerFactory();
    }

    public ExecutionContext createRddExecutionContext(int jobId) {
        return new RddExecutionContext(this.openLineageEventEmitter);
    }

    public Optional<ExecutionContext> createSparkSQLExecutionContext(long executionId) {
        QueryExecution queryExecution = SQLExecution.getQueryExecution((long)executionId);
        if (queryExecution == null) {
            log.error("Query execution is null: can't emit event for executionId {}", (Object)executionId);
            return Optional.empty();
        }
        SparkSession sparkSession = queryExecution.sparkSession();
        OpenLineageContext olContext = OpenLineageContext.builder().sparkSession(sparkSession).sparkContext(sparkSession.sparkContext()).openLineage(new OpenLineage(Versions.OPEN_LINEAGE_PRODUCER_URI)).queryExecution(queryExecution).customEnvironmentVariables(this.openLineageEventEmitter.getCustomEnvironmentVariables().orElse(Collections.emptyList())).vendors(Vendors.getVendors()).meterRegistry(this.meterRegistry).openLineageConfig(this.config).build();
        OpenLineageRunEventBuilder runEventBuilder = new OpenLineageRunEventBuilder(olContext, this.handlerFactory);
        return Optional.of(new SparkSQLExecutionContext(executionId, this.openLineageEventEmitter, olContext, runEventBuilder));
    }

    public Optional<ExecutionContext> createSparkSQLExecutionContext(SparkListenerSQLExecutionEnd event) {
        return ContextFactory.executionFromCompleteEvent(event).map(queryExecution -> {
            SparkSession sparkSession = queryExecution.sparkSession();
            OpenLineageContext olContext = OpenLineageContext.builder().sparkSession(sparkSession).sparkContext(sparkSession.sparkContext()).openLineage(new OpenLineage(Versions.OPEN_LINEAGE_PRODUCER_URI)).queryExecution((QueryExecution)queryExecution).customEnvironmentVariables(this.openLineageEventEmitter.getCustomEnvironmentVariables().orElse(Collections.emptyList())).vendors(Vendors.getVendors()).meterRegistry(this.meterRegistry).openLineageConfig(this.config).build();
            OpenLineageRunEventBuilder runEventBuilder = new OpenLineageRunEventBuilder(olContext, this.handlerFactory);
            return new SparkSQLExecutionContext(event.executionId(), this.openLineageEventEmitter, olContext, runEventBuilder);
        });
    }

    public static Optional<QueryExecution> executionFromCompleteEvent(SparkListenerSQLExecutionEnd event) {
        try {
            return Optional.of((QueryExecution)MethodUtils.invokeMethod((Object)event, "qe", null));
        }
        catch (NoSuchMethodException e) {
            return Optional.empty();
        }
        catch (ClassCastException | IllegalAccessException | InvocationTargetException e) {
            log.warn("Invoking qe method failed", (Throwable)e);
            return Optional.empty();
        }
    }

    public MeterRegistry getMeterRegistry() {
        return this.meterRegistry;
    }

    public SparkOpenLineageConfig getConfig() {
        return this.config;
    }
}

