/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.lifecycle;

import com.google.common.collect.ImmutableMap;
import io.openlineage.spark.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import io.openlineage.spark.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.openlineage.spark.shaded.com.fasterxml.jackson.annotation.JsonIgnoreType;
import io.openlineage.spark.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import io.openlineage.spark.shaded.com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import org.apache.commons.lang.reflect.MethodUtils;
import org.apache.spark.Partition;
import org.apache.spark.api.python.PythonRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.SQLExecutionRDD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LogicalPlanSerializer {
    private static final Logger log = LoggerFactory.getLogger(LogicalPlanSerializer.class);
    private static final int MAX_SERIALIZED_PLAN_LENGTH = 50000;
    private final Object objectMapper = this.getObjectMapper();
    private static final String UNSHADED_JACKSON_PACKAGE = "com.".trim() + "fasterxml.jackson";

    public LogicalPlanSerializer() {
        try {
            Class<?> clazz = Class.forName(UNSHADED_JACKSON_PACKAGE + ".databind.introspect.ClassIntrospector$MixInResolver");
            Object resolver = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new InvocationHandler(){
                LogicalPlanMixinResolver resolver = new LogicalPlanMixinResolver();

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    return MethodUtils.invokeMethod((Object)this.resolver, (String)method.getName(), (Object[])args);
                }
            });
            MethodUtils.invokeMethod((Object)this.objectMapper, (String)"registerModule", (Object)Class.forName(UNSHADED_JACKSON_PACKAGE + ".module.scala.DefaultScalaModule$").getDeclaredField("MODULE$").get(null));
            MethodUtils.invokeMethod((Object)this.objectMapper, (String)"setMixInResolver", (Object)resolver);
        }
        catch (Error | Exception t) {
            log.warn("Can't register jackson scala module for serializing LogicalPlan", t);
        }
    }

    private Object getObjectMapper() {
        try {
            return Class.forName(UNSHADED_JACKSON_PACKAGE + ".databind.ObjectMapper").getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            log.warn("Couldn't instantiate ObjectMapper", (Throwable)e);
            return new ObjectMapper();
        }
    }

    private String writeValueAsString(LogicalPlan x) {
        try {
            return (String)MethodUtils.invokeMethod((Object)this.objectMapper, (String)"writeValueAsString", (Object)x);
        }
        catch (Exception e) {
            log.warn("Unable to writeValueAsString", (Throwable)e);
            return "";
        }
    }

    private String writeValueAsString(String x) {
        try {
            return (String)MethodUtils.invokeMethod((Object)this.objectMapper, (String)"writeValueAsString", (Object)x);
        }
        catch (Exception e) {
            log.warn("Unable to writeValueAsString", (Throwable)e);
            return "";
        }
    }

    public String serialize(LogicalPlan x) {
        String serializedPlan = this.writeValueAsString(x);
        if (serializedPlan.length() > 50000) {
            serializedPlan = this.writeValueAsString(serializedPlan.substring(0, 50000));
        }
        return serializedPlan;
    }

    static class LogicalPlanMixinResolver
    implements ClassIntrospector.MixInResolver {
        private static Map<Class, Class> concreteMixin;

        LogicalPlanMixinResolver() {
        }

        @Override
        public Class<?> findMixInClassFor(Class<?> cls) {
            return concreteMixin.getOrDefault(cls, ChildMixIn.class);
        }

        @Override
        public ClassIntrospector.MixInResolver copy() {
            return this;
        }

        static {
            ImmutableMap.Builder builder = ImmutableMap.builder().put(PythonRDD.class, PythonRDDMixin.class).put(ClassLoader.class, IgnoredType.class).put(RDD.class, RDDMixin.class).put(SQLExecutionRDD.class, SqlConfigMixin.class).put(FunctionRegistry.class, IgnoredType.class);
            try {
                Class<?> c = ChildMixIn.class.getClassLoader().loadClass("java.lang.Module");
                builder.put(c, IgnoredType.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            concreteMixin = builder.build();
        }
    }

    public static class RDDMixin {
        @JsonIgnore
        private Partition[] partitions;

        @JsonIgnore
        public Boolean isEmpty() {
            return false;
        }

        @JsonIgnore
        public Partition[] getPartitions() {
            return new Partition[0];
        }
    }

    public static class PythonRDDMixin {
        @JsonIgnore
        private PythonRDDMixin asJavaRDD;
    }

    @JsonIgnoreProperties(value={"sqlConfigs", "sqlConfExecutorSide"})
    public static class SqlConfigMixin {
    }

    @JsonIgnoreProperties(value={"child", "containsChild", "canonicalized", "constraints", "data", "deltaLog", "limitExpr"})
    abstract class ChildMixIn {
        ChildMixIn() {
        }
    }

    @JsonIgnoreType
    public static class IgnoredType {
    }
}

