/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.lifecycle;

import io.openlineage.spark.agent.util.ScalaConversionUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import org.apache.spark.Dependency;
import org.apache.spark.rdd.HadoopRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.scheduler.StageInfo;
import org.apache.spark.sql.execution.ShuffledRowRDD;
import org.apache.spark.sql.execution.datasources.FileScanRDD;
import org.apache.spark.storage.RDDInfo;

public class Rdds {
    public static Set<RDD<?>> flattenRDDs(RDD<?> rdd) {
        HashSet rdds = new HashSet();
        rdds.add(rdd);
        if (rdd instanceof ShuffledRowRDD) {
            rdds.addAll(Rdds.flattenRDDs(((ShuffledRowRDD)rdd).dependency().rdd()));
        }
        List<Dependency> deps = ScalaConversionUtils.fromSeq(rdd.dependencies());
        for (Dependency dep : deps) {
            rdds.addAll(Rdds.flattenRDDs(dep.rdd()));
        }
        return rdds;
    }

    static String toString(SparkListenerJobStart jobStart) {
        StringBuilder sb = new StringBuilder();
        sb.append("start: ").append(jobStart.properties().toString()).append("\n");
        List<StageInfo> stageInfos = ScalaConversionUtils.fromSeq(jobStart.stageInfos());
        for (StageInfo stageInfo : stageInfos) {
            sb.append("  ").append("stageInfo: ").append(stageInfo.stageId()).append(" ").append(stageInfo.name()).append("\n");
            List<RDDInfo> rddInfos = ScalaConversionUtils.fromSeq(stageInfo.rddInfos());
            for (RDDInfo rddInfo : rddInfos) {
                sb.append("    ").append("rddInfo: ").append(rddInfo).append("\n");
            }
        }
        return sb.toString();
    }

    public static List<RDD<?>> findFileLikeRdds(RDD<?> rdd) {
        ArrayList ret = new ArrayList();
        Stack deps = new Stack();
        deps.add(rdd);
        while (!deps.isEmpty()) {
            RDD cur = (RDD)deps.pop();
            deps.addAll(ScalaConversionUtils.fromSeq(cur.getDependencies()).stream().map(Dependency::rdd).collect(Collectors.toList()));
            if (cur instanceof HadoopRDD) {
                ret.add(cur);
                continue;
            }
            if (!(cur instanceof FileScanRDD)) continue;
            ret.add(cur);
        }
        return ret;
    }
}

