/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.lifecycle;

import com.google.common.collect.ImmutableList;
import io.openlineage.client.OpenLineage;
import io.openlineage.spark.agent.lifecycle.DatasetBuilderFactory;
import io.openlineage.spark.agent.lifecycle.Spark32DatasetBuilderFactory;
import io.openlineage.spark.agent.lifecycle.plan.CommandPlanVisitor;
import io.openlineage.spark.agent.lifecycle.plan.SaveIntoDataSourceCommandVisitor;
import io.openlineage.spark.agent.util.DeltaUtils;
import io.openlineage.spark.api.DatasetFactory;
import io.openlineage.spark.api.OpenLineageContext;
import io.openlineage.spark3.agent.lifecycle.plan.AppendDataDatasetBuilder;
import io.openlineage.spark3.agent.lifecycle.plan.DataSourceV2RelationInputDatasetBuilder;
import io.openlineage.spark3.agent.lifecycle.plan.DataSourceV2RelationOutputDatasetBuilder;
import io.openlineage.spark3.agent.lifecycle.plan.DataSourceV2ScanRelationInputDatasetBuilder;
import io.openlineage.spark3.agent.lifecycle.plan.InMemoryRelationInputDatasetBuilder;
import io.openlineage.spark3.agent.lifecycle.plan.LogicalRelationDatasetBuilder;
import io.openlineage.spark3.agent.lifecycle.plan.MergeIntoCommandEdgeInputDatasetBuilder;
import io.openlineage.spark3.agent.lifecycle.plan.MergeIntoCommandEdgeOutputDatasetBuilder;
import io.openlineage.spark3.agent.lifecycle.plan.MergeIntoCommandInputDatasetBuilder;
import io.openlineage.spark3.agent.lifecycle.plan.MergeIntoCommandOutputDatasetBuilder;
import io.openlineage.spark3.agent.lifecycle.plan.SparkExtensionV1InputDatasetBuilder;
import io.openlineage.spark3.agent.lifecycle.plan.SparkExtensionV1OutputDatasetBuilder;
import io.openlineage.spark3.agent.lifecycle.plan.SubqueryAliasInputDatasetBuilder;
import io.openlineage.spark3.agent.lifecycle.plan.SubqueryAliasOutputDatasetBuilder;
import io.openlineage.spark3.agent.lifecycle.plan.TableContentChangeDatasetBuilder;
import io.openlineage.spark32.agent.lifecycle.plan.AlterTableCommandDatasetBuilder;
import io.openlineage.spark33.agent.lifecycle.plan.ReplaceIcebergDataDatasetBuilder;
import io.openlineage.spark34.agent.lifecycle.plan.column.CreateReplaceInputDatasetBuilder;
import io.openlineage.spark35.agent.lifecycle.plan.CreateReplaceOutputDatasetBuilder;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.PartialFunction;

public class Spark35DatasetBuilderFactory
extends Spark32DatasetBuilderFactory
implements DatasetBuilderFactory {
    private static final Logger log = LoggerFactory.getLogger(Spark35DatasetBuilderFactory.class);

    @Override
    public Collection<PartialFunction<Object, List<OpenLineage.InputDataset>>> getInputBuilders(OpenLineageContext context) {
        DatasetFactory<OpenLineage.InputDataset> datasetFactory = DatasetFactory.input(context);
        ImmutableList.Builder builder = ImmutableList.builder().add(new LogicalRelationDatasetBuilder(context, (DatasetFactory)datasetFactory, true)).add((Object)new InMemoryRelationInputDatasetBuilder(context)).add((Object)new CommandPlanVisitor(context)).add((Object)new DataSourceV2ScanRelationInputDatasetBuilder(context, datasetFactory)).add((Object)new SubqueryAliasInputDatasetBuilder(context)).add((Object)new CreateReplaceInputDatasetBuilder(context)).add((Object)new SparkExtensionV1InputDatasetBuilder(context)).add((Object)new MergeIntoCommandEdgeInputDatasetBuilder(context)).add((Object)new DataSourceV2RelationInputDatasetBuilder(context, datasetFactory));
        if (DeltaUtils.hasMergeIntoCommandClass()) {
            builder.add((Object)new MergeIntoCommandInputDatasetBuilder(context));
        }
        return builder.build();
    }

    @Override
    public Collection<PartialFunction<Object, List<OpenLineage.OutputDataset>>> getOutputBuilders(OpenLineageContext context) {
        DatasetFactory<OpenLineage.OutputDataset> datasetFactory = DatasetFactory.output(context);
        ImmutableList.Builder builder = ImmutableList.builder().add(new LogicalRelationDatasetBuilder(context, (DatasetFactory)datasetFactory, false)).add((Object)new SaveIntoDataSourceCommandVisitor(context)).add((Object)new AppendDataDatasetBuilder(context, datasetFactory)).add((Object)new DataSourceV2RelationOutputDatasetBuilder(context, datasetFactory)).add((Object)new TableContentChangeDatasetBuilder(context)).add((Object)new CreateReplaceOutputDatasetBuilder(context)).add((Object)new SparkExtensionV1OutputDatasetBuilder(context)).add((Object)new SubqueryAliasOutputDatasetBuilder(context)).add((Object)new MergeIntoCommandEdgeOutputDatasetBuilder(context)).add((Object)new AlterTableCommandDatasetBuilder(context));
        if (ReplaceIcebergDataDatasetBuilder.hasClasses()) {
            builder.add((Object)new ReplaceIcebergDataDatasetBuilder(context));
        }
        if (DeltaUtils.hasMergeIntoCommandClass()) {
            builder.add((Object)new MergeIntoCommandOutputDatasetBuilder(context));
        }
        return builder.build();
    }
}

