/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.lifecycle;

import io.openlineage.spark.agent.lifecycle.VisitorFactory;
import org.apache.spark.package$;

class VisitorFactoryProvider {
    private static final String SPARK2_FACTORY_NAME = "io.openlineage.spark.agent.lifecycle.Spark2VisitorFactoryImpl";
    private static final String SPARK3_FACTORY_NAME = "io.openlineage.spark.agent.lifecycle.Spark3VisitorFactoryImpl";
    private static final String SPARK32_FACTORY_NAME = "io.openlineage.spark.agent.lifecycle.Spark32VisitorFactoryImpl";

    VisitorFactoryProvider() {
    }

    static VisitorFactory getInstance() {
        String version = package$.MODULE$.SPARK_VERSION();
        try {
            return (VisitorFactory)Class.forName(VisitorFactoryProvider.getVisitorFactoryForVersion(version)).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Can't instantiate visitor factory for version: %s", version), e);
        }
    }

    static String getVisitorFactoryForVersion(String version) {
        if (version.startsWith("2.")) {
            return SPARK2_FACTORY_NAME;
        }
        if (version.startsWith("3.2")) {
            return SPARK32_FACTORY_NAME;
        }
        return SPARK3_FACTORY_NAME;
    }
}

