/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.lifecycle.plan;

import io.openlineage.client.OpenLineage;
import io.openlineage.spark.agent.util.PathUtils;
import io.openlineage.spark.api.OpenLineageContext;
import io.openlineage.spark.api.QueryPlanVisitor;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.command.AlterTableSetLocationCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlterTableSetLocationCommandVisitor
extends QueryPlanVisitor<AlterTableSetLocationCommand, OpenLineage.OutputDataset> {
    private static final Logger log = LoggerFactory.getLogger(AlterTableSetLocationCommandVisitor.class);

    public AlterTableSetLocationCommandVisitor(OpenLineageContext context) {
        super(context);
    }

    public List<OpenLineage.OutputDataset> apply(LogicalPlan x) {
        Optional<CatalogTable> tableOption = this.catalogTableFor(((AlterTableSetLocationCommand)x).tableName());
        if (!tableOption.isPresent()) {
            return Collections.emptyList();
        }
        CatalogTable catalogTable = tableOption.get();
        return Collections.singletonList(this.outputDataset().getDataset(PathUtils.fromCatalogTable(catalogTable), catalogTable.schema()));
    }
}

