/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.lifecycle.plan;

import io.openlineage.client.OpenLineage;
import io.openlineage.client.utils.DatasetIdentifier;
import io.openlineage.spark.agent.util.PathUtils;
import io.openlineage.spark.agent.util.PlanUtils;
import io.openlineage.spark.api.DatasetFactory;
import io.openlineage.spark.api.OpenLineageContext;
import io.openlineage.spark.api.QueryPlanVisitor;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.command.DropTableCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropTableCommandVisitor
extends QueryPlanVisitor<DropTableCommand, OpenLineage.OutputDataset> {
    private static final Logger log = LoggerFactory.getLogger(DropTableCommandVisitor.class);

    public DropTableCommandVisitor(OpenLineageContext context) {
        super(context);
    }

    public List<OpenLineage.OutputDataset> apply(LogicalPlan x) {
        DropTableCommand command = (DropTableCommand)x;
        Optional<CatalogTable> table = this.catalogTableFor(command.tableName());
        if (table.isPresent()) {
            DatasetIdentifier datasetIdentifier = PathUtils.fromCatalogTable(table.get());
            DatasetFactory<OpenLineage.OutputDataset> factory = this.outputDataset();
            return Collections.singletonList(factory.getDataset(datasetIdentifier, new OpenLineage.DatasetFacetsBuilder().schema(null).dataSource(PlanUtils.datasourceFacet(this.context.getOpenLineage(), datasetIdentifier.getNamespace())).lifecycleStateChange(this.context.getOpenLineage().newLifecycleStateChangeDatasetFacet(OpenLineage.LifecycleStateChangeDatasetFacet.LifecycleStateChange.DROP, null))));
        }
        return Collections.emptyList();
    }
}

