/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.lifecycle.plan;

import io.openlineage.client.OpenLineage;
import io.openlineage.client.utils.DatasetIdentifier;
import io.openlineage.spark.agent.util.PathUtils;
import io.openlineage.spark.api.DatasetFactory;
import io.openlineage.spark.api.OpenLineageContext;
import io.openlineage.spark.api.QueryPlanVisitor;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.apache.spark.sql.catalyst.catalog.HiveTableRelation;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;

public class HiveTableRelationVisitor<D extends OpenLineage.Dataset>
extends QueryPlanVisitor<HiveTableRelation, D> {
    private final DatasetFactory<D> factory;

    public HiveTableRelationVisitor(@NonNull OpenLineageContext context, DatasetFactory<D> factory) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.factory = factory;
    }

    public List<D> apply(LogicalPlan x) {
        HiveTableRelation hiveTable = (HiveTableRelation)x;
        DatasetIdentifier datasetId = PathUtils.fromCatalogTable(hiveTable.tableMeta());
        return Collections.singletonList(this.factory.getDataset(datasetId, x.schema()));
    }
}

