/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.lifecycle.plan;

import io.openlineage.client.OpenLineage;
import io.openlineage.client.utils.DatasetIdentifier;
import io.openlineage.spark.agent.lifecycle.plan.handlers.ExtensionLineageRelationHandler;
import io.openlineage.spark.agent.lifecycle.plan.handlers.JdbcRelationHandler;
import io.openlineage.spark.agent.util.PathUtils;
import io.openlineage.spark.agent.util.PlanUtils;
import io.openlineage.spark.agent.util.ScalaConversionUtils;
import io.openlineage.spark.api.AbstractQueryPlanDatasetBuilder;
import io.openlineage.spark.api.DatasetFactory;
import io.openlineage.spark.api.OpenLineageContext;
import io.openlineage.spark.extension.scala.v1.LineageRelation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRelation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogicalRelationDatasetBuilder<D extends OpenLineage.Dataset>
extends AbstractQueryPlanDatasetBuilder<SparkListenerEvent, LogicalRelation, D> {
    private static final Logger log = LoggerFactory.getLogger(LogicalRelationDatasetBuilder.class);
    private final DatasetFactory<D> datasetFactory;

    public LogicalRelationDatasetBuilder(OpenLineageContext context, DatasetFactory<D> datasetFactory, boolean searchDependencies) {
        super(context, searchDependencies);
        this.datasetFactory = datasetFactory;
    }

    @Override
    public boolean isDefinedAtLogicalPlan(LogicalPlan x) {
        if (x instanceof LogicalRelation && this.isSingleNodeLogicalPlan(x) && !this.searchDependencies) {
            return false;
        }
        return x instanceof LogicalRelation && (((LogicalRelation)x).relation() instanceof HadoopFsRelation || ((LogicalRelation)x).relation() instanceof JDBCRelation || ((LogicalRelation)x).relation() instanceof LineageRelation || ((LogicalRelation)x).catalogTable().isDefined());
    }

    private boolean isSingleNodeLogicalPlan(LogicalPlan x) {
        return this.context.getQueryExecution().map(qe -> qe.optimizedPlan()).filter(p -> p.equals(x)).isPresent() && (x.children() == null || x.children().isEmpty());
    }

    @Override
    public List<D> apply(LogicalRelation logRel) {
        throw new UnsupportedOperationException("apply(LogicalPlay) is not implemented");
    }

    @Override
    public List<D> apply(SparkListenerEvent event, LogicalRelation logRel) {
        if (logRel.relation() instanceof LineageRelation) {
            return new ExtensionLineageRelationHandler<D>(this.context, this.datasetFactory).handleRelation(event, logRel);
        }
        if (logRel.catalogTable() != null && logRel.catalogTable().isDefined()) {
            return this.handleCatalogTable(logRel);
        }
        if (logRel.relation() instanceof HadoopFsRelation) {
            return this.handleHadoopFsRelation(logRel);
        }
        if (logRel.relation() instanceof JDBCRelation) {
            return new JdbcRelationHandler<D>(this.datasetFactory).handleRelation(logRel);
        }
        throw new IllegalArgumentException("Expected logical plan to be either HadoopFsRelation, JDBCRelation, or CatalogTable but was " + logRel);
    }

    private List<D> handleCatalogTable(LogicalRelation logRel) {
        CatalogTable catalogTable = (CatalogTable)logRel.catalogTable().get();
        DatasetIdentifier di = PathUtils.fromCatalogTable(catalogTable);
        OpenLineage.DatasetFacetsBuilder datasetFacetsBuilder = this.context.getOpenLineage().newDatasetFacetsBuilder();
        datasetFacetsBuilder.schema(PlanUtils.schemaFacet(this.context.getOpenLineage(), logRel.schema()));
        datasetFacetsBuilder.dataSource(PlanUtils.datasourceFacet(this.context.getOpenLineage(), di.getNamespace()));
        this.getDatasetVersion(logRel).map(version -> datasetFacetsBuilder.version(this.context.getOpenLineage().newDatasetVersionDatasetFacet((String)version)));
        return Collections.singletonList(this.datasetFactory.getDataset(di, datasetFacetsBuilder));
    }

    private List<D> handleHadoopFsRelation(LogicalRelation x) {
        HadoopFsRelation relation = (HadoopFsRelation)x.relation();
        try {
            return this.context.getSparkSession().map(session -> {
                Configuration hadoopConfig = session.sessionState().newHadoopConfWithOptions(relation.options());
                OpenLineage.DatasetFacetsBuilder datasetFacetsBuilder = this.context.getOpenLineage().newDatasetFacetsBuilder();
                this.getDatasetVersion(x).map(version -> datasetFacetsBuilder.version(this.context.getOpenLineage().newDatasetVersionDatasetFacet((String)version)));
                List<Path> rootPaths = ScalaConversionUtils.fromSeq(relation.location().rootPaths());
                if (this.isSingleFileRelation(rootPaths, hadoopConfig)) {
                    return Collections.singletonList(this.datasetFactory.getDataset(((Path)rootPaths.stream().findFirst().get()).toUri(), relation.schema(), datasetFacetsBuilder));
                }
                return rootPaths.stream().map(p -> PlanUtils.getDirectoryPath(p, hadoopConfig)).distinct().map(p -> this.datasetFactory.getDataset(p.toUri(), relation.schema(), datasetFacetsBuilder)).collect(Collectors.toList());
            }).orElse(Collections.emptyList());
        }
        catch (Exception e) {
            ArrayList<D> inputDatasets = new ArrayList<D>();
            ArrayList paths = new ArrayList(ScalaConversionUtils.fromSeq(relation.location().rootPaths()));
            for (Path p : paths) {
                inputDatasets.add(this.datasetFactory.getDataset(p.toUri(), relation.schema()));
            }
            if (inputDatasets.isEmpty()) {
                return Collections.emptyList();
            }
            return inputDatasets;
        }
    }

    private boolean isSingleFileRelation(Collection<Path> paths, Configuration hadoopConfig) {
        if (paths.size() != 1) {
            return false;
        }
        try {
            Path path = paths.stream().findFirst().get();
            return path.getFileSystem(hadoopConfig).isFile(path);
        }
        catch (IOException e) {
            return false;
        }
    }

    protected Optional<String> getDatasetVersion(LogicalRelation x) {
        return Optional.empty();
    }
}

