/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.lifecycle.plan;

import com.google.common.collect.ImmutableMap;
import io.openlineage.client.OpenLineage;
import io.openlineage.spark.agent.lifecycle.plan.KafkaRelationVisitor;
import io.openlineage.spark.agent.lifecycle.plan.KustoRelationVisitor;
import io.openlineage.spark.agent.util.DatasetFacetsUtils;
import io.openlineage.spark.agent.util.ExtensionPlanUtils;
import io.openlineage.spark.agent.util.PathUtils;
import io.openlineage.spark.agent.util.PlanUtils;
import io.openlineage.spark.agent.util.ScalaConversionUtils;
import io.openlineage.spark.api.AbstractQueryPlanDatasetBuilder;
import io.openlineage.spark.api.OpenLineageContext;
import io.openlineage.spark.extension.scala.v1.LineageRelationProvider;
import java.net.URI;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.SaveIntoDataSourceCommand;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.RelationProvider;
import org.apache.spark.sql.sources.SchemaRelationProvider;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.collection.immutable.Map;

public class SaveIntoDataSourceCommandVisitor
extends AbstractQueryPlanDatasetBuilder<SparkListenerEvent, SaveIntoDataSourceCommand, OpenLineage.OutputDataset> {
    private static final Logger log = LoggerFactory.getLogger(SaveIntoDataSourceCommandVisitor.class);

    public SaveIntoDataSourceCommandVisitor(OpenLineageContext context) {
        super(context, false);
    }

    @Override
    public boolean isDefinedAtLogicalPlan(LogicalPlan x) {
        if (this.context.getSparkSession().isPresent() && x instanceof SaveIntoDataSourceCommand) {
            SaveIntoDataSourceCommand command = (SaveIntoDataSourceCommand)x;
            if (PlanUtils.safeIsInstanceOf(command.dataSource(), "com.google.cloud.spark.bigquery.BigQueryRelationProvider")) {
                return false;
            }
            return command.dataSource() instanceof SchemaRelationProvider || command.dataSource() instanceof LineageRelationProvider || command.dataSource() instanceof RelationProvider;
        }
        return false;
    }

    @Override
    public boolean isDefinedAt(SparkListenerEvent x) {
        return super.isDefinedAt(x) && this.context.getQueryExecution().filter(qe -> this.isDefinedAtLogicalPlan(qe.optimizedPlan())).isPresent();
    }

    @Override
    public List<OpenLineage.OutputDataset> apply(SaveIntoDataSourceCommand cmd) {
        throw new UnsupportedOperationException("apply(LogicalPlay) is not implemented");
    }

    @Override
    public List<OpenLineage.OutputDataset> apply(SparkListenerEvent event, SaveIntoDataSourceCommand command) {
        BaseRelation relation;
        OpenLineage.LifecycleStateChangeDatasetFacet.LifecycleStateChange lifecycleStateChange;
        if (command.dataSource() instanceof LineageRelationProvider) {
            LineageRelationProvider provider = (LineageRelationProvider)command.dataSource();
            return Collections.singletonList(this.outputDataset().getDataset(provider.getLineageDatasetIdentifier(ExtensionPlanUtils.context(event, this.context), this.context.getSparkSession().get().sqlContext(), command.options()), this.getSchema(command)));
        }
        if (KafkaRelationVisitor.isKafkaSource(command.dataSource())) {
            return KafkaRelationVisitor.createKafkaDatasets(this.outputDataset(), command.dataSource(), (Map<String, String>)command.options(), command.mode(), command.schema());
        }
        if (KustoRelationVisitor.isKustoSource(command.dataSource())) {
            return KustoRelationVisitor.createKustoDatasets(this.outputDataset(), (Map<String, String>)command.options(), command.schema());
        }
        StructType schema = this.getSchema(command);
        OpenLineage.LifecycleStateChangeDatasetFacet.LifecycleStateChange lifecycleStateChange2 = lifecycleStateChange = SaveMode.Overwrite == command.mode() ? OpenLineage.LifecycleStateChangeDatasetFacet.LifecycleStateChange.OVERWRITE : OpenLineage.LifecycleStateChangeDatasetFacet.LifecycleStateChange.CREATE;
        if (command.dataSource().getClass().getName().contains("DeltaDataSource") && command.options().contains((Object)"path")) {
            URI uri = URI.create((String)command.options().get((Object)"path").get());
            return Collections.singletonList(this.outputDataset().getDataset(PathUtils.fromURI(uri, "file"), schema, lifecycleStateChange));
        }
        SQLContext sqlContext = this.context.getSparkSession().get().sqlContext();
        try {
            RelationProvider p;
            if (command.dataSource() instanceof RelationProvider) {
                p = (RelationProvider)command.dataSource();
                relation = p.createRelation(sqlContext, command.options());
            } else {
                p = (SchemaRelationProvider)command.dataSource();
                relation = p.createRelation(sqlContext, command.options(), schema);
            }
        }
        catch (Exception ex) {
            if (ex instanceof SQLException) {
                log.warn("Can't create relation: ", (Throwable)ex);
                return Collections.emptyList();
            }
            throw ex;
        }
        LogicalRelation logicalRelation = new LogicalRelation(relation, ScalaConversionUtils.asScalaSeqEmpty(), Option.empty(), command.isStreaming());
        return ((List)this.delegate(this.context.getOutputDatasetQueryPlanVisitors(), this.context.getOutputDatasetBuilders(), event).applyOrElse((Object)logicalRelation, ScalaConversionUtils.toScalaFn(lp -> Collections.emptyList()))).stream().map(ds -> {
            ImmutableMap.Builder facetsMap = ImmutableMap.builder();
            if (ds.getFacets().getAdditionalProperties() != null) {
                facetsMap.putAll(ds.getFacets().getAdditionalProperties());
            }
            ds.getFacets().getAdditionalProperties().putAll((java.util.Map<String, OpenLineage.DatasetFacet>)facetsMap.build());
            OpenLineage.DatasetFacets facets = DatasetFacetsUtils.copyToBuilder(this.context, ds.getFacets()).lifecycleStateChange(this.context.getOpenLineage().newLifecycleStateChangeDatasetFacet(OpenLineage.LifecycleStateChangeDatasetFacet.LifecycleStateChange.OVERWRITE, null)).build();
            OpenLineage.OutputDataset newDs = this.context.getOpenLineage().newOutputDataset(ds.getNamespace(), ds.getName(), facets, ds.getOutputFacets());
            return newDs;
        }).collect(Collectors.toList());
    }

    private StructType getSchema(SaveIntoDataSourceCommand command) {
        StructType schema = command.schema();
        if ((schema == null || schema.fields() == null || schema.fields().length == 0) && command.query() != null && command.query().output() != null) {
            schema = PlanUtils.toStructType(ScalaConversionUtils.fromSeq(command.query().output()));
        }
        return schema;
    }
}

