/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.lifecycle.plan.handlers;

import io.openlineage.client.OpenLineage;
import io.openlineage.client.utils.DatasetIdentifier;
import io.openlineage.spark.agent.util.ExtensionPlanUtils;
import io.openlineage.spark.api.DatasetFactory;
import io.openlineage.spark.api.OpenLineageContext;
import io.openlineage.spark.extension.scala.v1.LineageRelation;
import java.util.Collections;
import java.util.List;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.sql.execution.datasources.LogicalRelation;

public class ExtensionLineageRelationHandler<D extends OpenLineage.Dataset> {
    private final DatasetFactory<D> datasetFactory;
    private final OpenLineageContext context;

    public ExtensionLineageRelationHandler(OpenLineageContext context, DatasetFactory<D> datasetFactory) {
        this.datasetFactory = datasetFactory;
        this.context = context;
    }

    public List<D> handleRelation(SparkListenerEvent event, LogicalRelation x) {
        if (!(x.relation() instanceof LineageRelation)) {
            return Collections.emptyList();
        }
        LineageRelation relation = (LineageRelation)x.relation();
        DatasetIdentifier di = relation.getLineageDatasetIdentifier(ExtensionPlanUtils.context(event, this.context));
        if (x.schema() != null) {
            return Collections.singletonList(this.datasetFactory.getDataset(di, x.schema()));
        }
        return Collections.singletonList(this.datasetFactory.getDataset(di, this.context.getOpenLineage().newDatasetFacetsBuilder()));
    }
}

