/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.lifecycle.plan.handlers;

import io.openlineage.client.OpenLineage;
import io.openlineage.spark.agent.util.JdbcSparkUtils;
import io.openlineage.spark.api.DatasetFactory;
import io.openlineage.sql.SqlMeta;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRelation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcRelationHandler<D extends OpenLineage.Dataset> {
    private static final Logger log = LoggerFactory.getLogger(JdbcRelationHandler.class);
    private final DatasetFactory<D> datasetFactory;

    public JdbcRelationHandler(DatasetFactory<D> datasetFactory) {
        this.datasetFactory = datasetFactory;
    }

    public List<D> handleRelation(LogicalRelation x) {
        JDBCRelation relation = (JDBCRelation)x.relation();
        return this.getDatasets(relation, relation.jdbcOptions().url());
    }

    public List<D> getDatasets(JDBCRelation relation, String url) {
        Optional<SqlMeta> sqlMeta = JdbcSparkUtils.extractQueryFromSpark(relation);
        if (!sqlMeta.isPresent()) {
            return Collections.emptyList();
        }
        return JdbcSparkUtils.getDatasets(this.datasetFactory, sqlMeta.get(), relation.schema(), url);
    }
}

