/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.util;

import com.google.cloud.spark.bigquery.BigQueryRelation;
import io.openlineage.client.utils.DatasetIdentifier;
import io.openlineage.spark.agent.lifecycle.plan.BigQueryNodeOutputVisitor;
import io.openlineage.spark.agent.util.ReflectionUtils;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class BigQueryUtils {
    public static boolean hasBigQueryClasses() {
        try {
            BigQueryNodeOutputVisitor.class.getClassLoader().loadClass("com.google.cloud.spark.bigquery.BigQueryRelation");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static Optional<Object> extractDatasetIdentifierFromTableId(Object tableId) {
        return Stream.of(ReflectionUtils.tryExecuteStaticMethodForClassName("com.google.cloud.bigquery.connector.common.BigQueryUtil", "friendlyTableName", tableId), ReflectionUtils.tryExecuteStaticMethodForClassName("com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.connector.common.BigQueryUtil", "friendlyTableName", tableId)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    public static List<DatasetIdentifier> extractDatasetIdentifier(BigQueryRelation bigQueryRelation) {
        return ReflectionUtils.tryExecuteMethod(bigQueryRelation, "getTableId", new Object[0]).flatMap(BigQueryUtils::extractDatasetIdentifierFromTableId).map(x -> new DatasetIdentifier((String)x, "namespace")).map(Collections::singletonList).orElseGet(Collections::emptyList);
    }
}

