/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Optional;
import org.apache.spark.SparkConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;

public class SparkConfUtils {
    private static final Logger log = LoggerFactory.getLogger(SparkConfUtils.class);
    private static final String metastoreUriKey = "spark.sql.hive.metastore.uris";
    private static final String metastoreHadoopUriKey = "spark.hadoop.hive.metastore.uris";

    public static Optional<String> findSparkConfigKey(SparkConf conf, String name) {
        Option opt = conf.getOption(name);
        if (opt.isDefined()) {
            return Optional.of(opt.get());
        }
        return Optional.empty();
    }

    public static Optional<URI> getMetastoreUri(SparkConf conf) {
        return Optional.ofNullable(SparkConfUtils.findSparkConfigKey(conf, metastoreUriKey).orElse(SparkConfUtils.findSparkConfigKey(conf, metastoreHadoopUriKey).orElse(null))).map(key -> {
            if (key.contains(",")) {
                return Arrays.stream(key.split(",")).findFirst().get();
            }
            return key;
        }).map(uri -> {
            try {
                return new URI((String)uri);
            }
            catch (URISyntaxException e) {
                return null;
            }
        });
    }
}

