/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.api;

import io.openlineage.client.OpenLineage;
import io.openlineage.client.utils.DatasetIdentifier;
import io.openlineage.spark.agent.util.PathUtils;
import io.openlineage.spark.agent.util.PlanUtils;
import io.openlineage.spark.api.OpenLineageContext;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.spark.sql.types.StructType;

public abstract class DatasetFactory<D extends OpenLineage.Dataset> {
    private final OpenLineageContext context;

    private DatasetFactory(OpenLineageContext context) {
        this.context = context;
    }

    abstract OpenLineage.Builder<D> datasetBuilder(String var1, String var2, OpenLineage.DatasetFacets var3);

    public static DatasetFactory<OpenLineage.InputDataset> input(final OpenLineageContext context) {
        return new DatasetFactory<OpenLineage.InputDataset>(context){

            @Override
            public OpenLineage.Builder<OpenLineage.InputDataset> datasetBuilder(String name, String namespace, OpenLineage.DatasetFacets datasetFacet) {
                return context.getOpenLineage().newInputDatasetBuilder().namespace(namespace).name(name).facets(datasetFacet);
            }
        };
    }

    public static DatasetFactory<OpenLineage.OutputDataset> output(final OpenLineageContext context) {
        return new DatasetFactory<OpenLineage.OutputDataset>(context){

            @Override
            public OpenLineage.Builder<OpenLineage.OutputDataset> datasetBuilder(String name, String namespace, OpenLineage.DatasetFacets datasetFacet) {
                return context.getOpenLineage().newOutputDatasetBuilder().namespace(namespace).name(name).facets(datasetFacet);
            }
        };
    }

    public D getDataset(String name, String namespace, StructType schema) {
        return (D)((OpenLineage.Dataset)this.datasetBuilder(name, namespace, this.datasetFacetBuilder(schema, namespace).build()).build());
    }

    public D getDataset(URI outputPath, StructType schema, OpenLineage.DatasetFacetsBuilder datasetFacetsBuilder) {
        String namespace = PlanUtils.namespaceUri(outputPath);
        datasetFacetsBuilder.schema(PlanUtils.schemaFacet(this.context.getOpenLineage(), schema)).dataSource(PlanUtils.datasourceFacet(this.context.getOpenLineage(), namespace));
        return this.getDataset(new DatasetIdentifier(outputPath.getPath(), namespace), datasetFacetsBuilder);
    }

    public D getDataset(URI outputPath, StructType schema) {
        String namespace = PlanUtils.namespaceUri(outputPath);
        return this.getDataset(PathUtils.fromURI(outputPath), this.datasetFacetBuilder(schema, namespace));
    }

    public D getDataset(DatasetIdentifier ident, StructType schema) {
        OpenLineage.DatasetFacetsBuilder facetsBuilder = this.datasetFacetBuilder(schema, ident.getNamespace());
        this.includeSymlinksFacet(facetsBuilder, ident);
        return this.getDataset(ident, facetsBuilder);
    }

    public D getDataset(DatasetIdentifier ident, StructType schema, OpenLineage.LifecycleStateChangeDatasetFacet.LifecycleStateChange lifecycleStateChange) {
        OpenLineage.DatasetFacetsBuilder facetsBuilder = this.datasetFacetBuilder(schema, ident.getNamespace());
        facetsBuilder.lifecycleStateChange(this.context.getOpenLineage().newLifecycleStateChangeDatasetFacet(lifecycleStateChange, null));
        this.includeSymlinksFacet(facetsBuilder, ident);
        return this.getDataset(new DatasetIdentifier(ident.getName(), ident.getNamespace()), facetsBuilder);
    }

    private void includeSymlinksFacet(OpenLineage.DatasetFacetsBuilder builder, DatasetIdentifier di) {
        if (!di.getSymlinks().isEmpty()) {
            List<OpenLineage.SymlinksDatasetFacetIdentifiers> symlinks = di.getSymlinks().stream().map(symlink -> this.context.getOpenLineage().newSymlinksDatasetFacetIdentifiersBuilder().name(symlink.getName()).namespace(symlink.getNamespace()).type(symlink.getType().toString()).build()).collect(Collectors.toList());
            builder.symlinks(this.context.getOpenLineage().newSymlinksDatasetFacet(symlinks));
        }
    }

    public D getDataset(DatasetIdentifier ident, OpenLineage.DatasetFacetsBuilder facetsBuilder) {
        this.includeSymlinksFacet(facetsBuilder, ident);
        return (D)((OpenLineage.Dataset)this.datasetBuilder(ident.getName(), ident.getNamespace(), facetsBuilder.build()).build());
    }

    private OpenLineage.DatasetFacetsBuilder datasetFacetBuilder(StructType schema, String namespaceUri) {
        return this.context.getOpenLineage().newDatasetFacetsBuilder().schema(PlanUtils.schemaFacet(this.context.getOpenLineage(), schema)).dataSource(PlanUtils.datasourceFacet(this.context.getOpenLineage(), namespaceUri));
    }
}

