/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.api;

import io.openlineage.client.OpenLineageConfig;
import io.openlineage.client.circuitBreaker.CircuitBreakerConfig;
import io.openlineage.client.transports.FacetsConfig;
import io.openlineage.client.transports.TransportConfig;
import io.openlineage.spark.shaded.com.fasterxml.jackson.annotation.JsonAnySetter;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;

public class SparkOpenLineageConfig
extends OpenLineageConfig<SparkOpenLineageConfig> {
    public static final String DEFAULT_NAMESPACE = "default";
    public static final String[] DEFAULT_DISABLED_FACETS = new String[]{"spark_unknown", "spark.logicalPlan"};
    public static final String DEFAULT_DEBUG_FACET = "disabled";
    @NonNull
    private String namespace;
    private String parentJobName;
    private String parentJobNamespace;
    private String parentRunId;
    private String overriddenAppName;
    @NonNull
    private String debugFacet;
    private JobNameConfig jobName;
    private JobConfig job;

    public SparkOpenLineageConfig(String namespace, String parentJobName, String parentJobNamespace, String parentRunId, String overriddenAppName, String debugFacet, JobNameConfig jobName, JobConfig job, TransportConfig transportConfig, FacetsConfig facetsConfig, CircuitBreakerConfig circuitBreaker, Map<String, Object> metricsConfig) {
        super(transportConfig, facetsConfig, circuitBreaker, metricsConfig);
        this.namespace = namespace;
        this.parentJobName = parentJobName;
        this.parentJobNamespace = parentJobNamespace;
        this.parentRunId = parentRunId;
        this.overriddenAppName = overriddenAppName;
        this.debugFacet = debugFacet;
        this.jobName = jobName;
        this.job = job;
    }

    @Override
    public FacetsConfig getFacetsConfig() {
        if (this.facetsConfig == null) {
            this.facetsConfig = new FacetsConfig();
        }
        if (this.facetsConfig.getDisabledFacets() == null) {
            this.facetsConfig.setDisabledFacets(DEFAULT_DISABLED_FACETS);
        }
        return this.facetsConfig;
    }

    public JobNameConfig getJobName() {
        if (this.jobName == null) {
            this.jobName = new JobNameConfig();
        }
        return this.jobName;
    }

    public String getNamespace() {
        if (this.namespace == null) {
            this.namespace = DEFAULT_NAMESPACE;
        }
        return this.namespace;
    }

    public String getDebugFacet() {
        if (this.debugFacet == null) {
            this.debugFacet = DEFAULT_DEBUG_FACET;
        }
        return this.debugFacet;
    }

    @Override
    public SparkOpenLineageConfig mergeWithNonNull(SparkOpenLineageConfig other) {
        return new SparkOpenLineageConfig(this.mergeWithDefaultValue(this.namespace, other.namespace, DEFAULT_NAMESPACE), this.mergePropertyWith(this.parentJobName, other.parentJobName), this.mergePropertyWith(this.parentJobNamespace, other.parentJobNamespace), this.mergePropertyWith(this.parentRunId, other.parentRunId), this.mergePropertyWith(this.overriddenAppName, other.overriddenAppName), this.mergeWithDefaultValue(this.debugFacet, other.debugFacet, DEFAULT_DEBUG_FACET), this.mergePropertyWith(this.jobName, other.jobName), this.mergePropertyWith(this.job, other.job), this.mergePropertyWith(this.transportConfig, other.transportConfig), this.mergePropertyWith(this.facetsConfig, other.facetsConfig), this.mergePropertyWith(this.circuitBreaker, other.circuitBreaker), this.mergePropertyWith(this.metricsConfig, other.metricsConfig));
    }

    public JobConfig getJob() {
        return this.job;
    }

    public SparkOpenLineageConfig() {
    }

    public String toString() {
        return "SparkOpenLineageConfig(namespace=" + this.getNamespace() + ", parentJobName=" + this.getParentJobName() + ", parentJobNamespace=" + this.getParentJobNamespace() + ", parentRunId=" + this.getParentRunId() + ", overriddenAppName=" + this.getOverriddenAppName() + ", debugFacet=" + this.getDebugFacet() + ", jobName=" + this.getJobName() + ", job=" + this.getJob() + ")";
    }

    public void setNamespace(@NonNull String namespace) {
        if (namespace == null) {
            throw new NullPointerException("namespace is marked non-null but is null");
        }
        this.namespace = namespace;
    }

    public void setParentJobName(String parentJobName) {
        this.parentJobName = parentJobName;
    }

    public String getParentJobName() {
        return this.parentJobName;
    }

    public void setParentJobNamespace(String parentJobNamespace) {
        this.parentJobNamespace = parentJobNamespace;
    }

    public String getParentJobNamespace() {
        return this.parentJobNamespace;
    }

    public void setParentRunId(String parentRunId) {
        this.parentRunId = parentRunId;
    }

    public String getParentRunId() {
        return this.parentRunId;
    }

    public void setOverriddenAppName(String overriddenAppName) {
        this.overriddenAppName = overriddenAppName;
    }

    public String getOverriddenAppName() {
        return this.overriddenAppName;
    }

    public void setDebugFacet(@NonNull String debugFacet) {
        if (debugFacet == null) {
            throw new NullPointerException("debugFacet is marked non-null but is null");
        }
        this.debugFacet = debugFacet;
    }

    public void setJobName(JobNameConfig jobName) {
        this.jobName = jobName;
    }

    public void setJob(JobConfig job) {
        this.job = job;
    }

    public static class JobOwnersConfig {
        @JsonAnySetter
        @NonNull
        private Map<String, String> additionalProperties = new HashMap<String, String>();

        public String toString() {
            return "SparkOpenLineageConfig.JobOwnersConfig(additionalProperties=" + this.getAdditionalProperties() + ")";
        }

        public void setAdditionalProperties(@NonNull Map<String, String> additionalProperties) {
            if (additionalProperties == null) {
                throw new NullPointerException("additionalProperties is marked non-null but is null");
            }
            this.additionalProperties = additionalProperties;
        }

        @NonNull
        public Map<String, String> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }

    public static class JobConfig {
        private JobOwnersConfig owners;

        public String toString() {
            return "SparkOpenLineageConfig.JobConfig(owners=" + this.getOwners() + ")";
        }

        public void setOwners(JobOwnersConfig owners) {
            this.owners = owners;
        }

        public JobOwnersConfig getOwners() {
            return this.owners;
        }
    }

    public static class JobNameConfig {
        @NonNull
        private Boolean appendDatasetName = true;
        @NonNull
        private Boolean replaceDotWithUnderscore = false;

        public String toString() {
            return "SparkOpenLineageConfig.JobNameConfig(appendDatasetName=" + this.getAppendDatasetName() + ", replaceDotWithUnderscore=" + this.getReplaceDotWithUnderscore() + ")";
        }

        public void setAppendDatasetName(@NonNull Boolean appendDatasetName) {
            if (appendDatasetName == null) {
                throw new NullPointerException("appendDatasetName is marked non-null but is null");
            }
            this.appendDatasetName = appendDatasetName;
        }

        @NonNull
        public Boolean getAppendDatasetName() {
            return this.appendDatasetName;
        }

        public void setReplaceDotWithUnderscore(@NonNull Boolean replaceDotWithUnderscore) {
            if (replaceDotWithUnderscore == null) {
                throw new NullPointerException("replaceDotWithUnderscore is marked non-null but is null");
            }
            this.replaceDotWithUnderscore = replaceDotWithUnderscore;
        }

        @NonNull
        public Boolean getReplaceDotWithUnderscore() {
            return this.replaceDotWithUnderscore;
        }
    }
}

