/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.shaded.org.apache.hc.core5.http.protocol;

import io.openlineage.spark.shaded.org.apache.hc.core5.annotation.Contract;
import io.openlineage.spark.shaded.org.apache.hc.core5.annotation.ThreadingBehavior;
import io.openlineage.spark.shaded.org.apache.hc.core5.http.EntityDetails;
import io.openlineage.spark.shaded.org.apache.hc.core5.http.HttpException;
import io.openlineage.spark.shaded.org.apache.hc.core5.http.HttpRequest;
import io.openlineage.spark.shaded.org.apache.hc.core5.http.HttpRequestInterceptor;
import io.openlineage.spark.shaded.org.apache.hc.core5.http.Method;
import io.openlineage.spark.shaded.org.apache.hc.core5.http.protocol.HttpContext;
import io.openlineage.spark.shaded.org.apache.hc.core5.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestConnControl
implements HttpRequestInterceptor {
    public static final HttpRequestInterceptor INSTANCE = new RequestConnControl();

    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getMethod();
        if (Method.CONNECT.isSame(method)) {
            return;
        }
        if (!request.containsHeader("Connection")) {
            if (request.containsHeader("Upgrade")) {
                request.addHeader("Connection", "upgrade");
            } else {
                request.addHeader("Connection", "keep-alive");
            }
        }
    }
}

