/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.shaded.org.apache.hc.core5.http.protocol;

import io.openlineage.spark.shaded.org.apache.hc.core5.annotation.Contract;
import io.openlineage.spark.shaded.org.apache.hc.core5.annotation.ThreadingBehavior;
import io.openlineage.spark.shaded.org.apache.hc.core5.http.EntityDetails;
import io.openlineage.spark.shaded.org.apache.hc.core5.http.Header;
import io.openlineage.spark.shaded.org.apache.hc.core5.http.HttpException;
import io.openlineage.spark.shaded.org.apache.hc.core5.http.HttpRequest;
import io.openlineage.spark.shaded.org.apache.hc.core5.http.HttpRequestInterceptor;
import io.openlineage.spark.shaded.org.apache.hc.core5.http.HttpVersion;
import io.openlineage.spark.shaded.org.apache.hc.core5.http.ProtocolException;
import io.openlineage.spark.shaded.org.apache.hc.core5.http.ProtocolVersion;
import io.openlineage.spark.shaded.org.apache.hc.core5.http.protocol.HttpContext;
import io.openlineage.spark.shaded.org.apache.hc.core5.net.URIAuthority;
import io.openlineage.spark.shaded.org.apache.hc.core5.util.Args;
import java.io.IOException;
import java.net.URISyntaxException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestValidateHost
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        Header header = request.getHeader("Host");
        if (header != null) {
            URIAuthority authority;
            try {
                authority = URIAuthority.create(header.getValue());
            }
            catch (URISyntaxException ex) {
                throw new ProtocolException(ex.getMessage(), ex);
            }
            request.setAuthority(authority);
        } else {
            ProtocolVersion version;
            ProtocolVersion protocolVersion = version = request.getVersion() != null ? request.getVersion() : HttpVersion.HTTP_1_1;
            if (version.greaterEquals(HttpVersion.HTTP_1_1)) {
                throw new ProtocolException("Host header is absent");
            }
        }
    }
}

