/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.shaded.org.apache.hc.core5.http2.frame;

import io.openlineage.spark.shaded.org.apache.hc.core5.http2.frame.FrameFactory;
import io.openlineage.spark.shaded.org.apache.hc.core5.http2.frame.FrameFlag;
import io.openlineage.spark.shaded.org.apache.hc.core5.http2.frame.FrameType;
import io.openlineage.spark.shaded.org.apache.hc.core5.http2.frame.RawFrame;
import io.openlineage.spark.shaded.org.apache.hc.core5.util.Args;
import java.nio.ByteBuffer;

public class DefaultFrameFactory
extends FrameFactory {
    public static final FrameFactory INSTANCE = new DefaultFrameFactory();

    @Override
    public RawFrame createHeaders(int streamId, ByteBuffer payload, boolean endHeaders, boolean endStream) {
        Args.positive(streamId, "Stream id");
        int flags = (endHeaders ? FrameFlag.END_HEADERS.value : 0) | (endStream ? FrameFlag.END_STREAM.value : 0);
        return new RawFrame(FrameType.HEADERS.getValue(), flags, streamId, payload);
    }

    @Override
    public RawFrame createContinuation(int streamId, ByteBuffer payload, boolean endHeaders) {
        Args.positive(streamId, "Stream id");
        int flags = endHeaders ? FrameFlag.END_HEADERS.value : 0;
        return new RawFrame(FrameType.CONTINUATION.getValue(), flags, streamId, payload);
    }

    @Override
    public RawFrame createPushPromise(int streamId, ByteBuffer payload, boolean endHeaders) {
        Args.positive(streamId, "Stream id");
        int flags = endHeaders ? FrameFlag.END_HEADERS.value : 0;
        return new RawFrame(FrameType.PUSH_PROMISE.getValue(), flags, streamId, payload);
    }

    @Override
    public RawFrame createData(int streamId, ByteBuffer payload, boolean endStream) {
        Args.positive(streamId, "Stream id");
        int flags = endStream ? FrameFlag.END_STREAM.value : 0;
        return new RawFrame(FrameType.DATA.getValue(), flags, streamId, payload);
    }
}

