/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.shaded.org.apache.hc.core5.reactor;

import io.openlineage.spark.shaded.org.apache.hc.core5.concurrent.FutureCallback;
import io.openlineage.spark.shaded.org.apache.hc.core5.net.NamedEndpoint;
import io.openlineage.spark.shaded.org.apache.hc.core5.reactor.ConnectionInitiator;
import io.openlineage.spark.shaded.org.apache.hc.core5.reactor.IOReactorService;
import io.openlineage.spark.shaded.org.apache.hc.core5.reactor.IOReactorShutdownException;
import io.openlineage.spark.shaded.org.apache.hc.core5.reactor.IOReactorStatus;
import io.openlineage.spark.shaded.org.apache.hc.core5.reactor.IOSession;
import io.openlineage.spark.shaded.org.apache.hc.core5.reactor.IOWorkers;
import io.openlineage.spark.shaded.org.apache.hc.core5.util.Args;
import io.openlineage.spark.shaded.org.apache.hc.core5.util.Timeout;
import java.net.SocketAddress;
import java.util.concurrent.Future;

abstract class AbstractIOReactorBase
implements ConnectionInitiator,
IOReactorService {
    AbstractIOReactorBase() {
    }

    @Override
    public final Future<IOSession> connect(NamedEndpoint remoteEndpoint, SocketAddress remoteAddress, SocketAddress localAddress, Timeout timeout, Object attachment, FutureCallback<IOSession> callback) throws IOReactorShutdownException {
        Args.notNull(remoteEndpoint, "Remote endpoint");
        if (this.getStatus().compareTo(IOReactorStatus.ACTIVE) > 0) {
            throw new IOReactorShutdownException("I/O reactor has been shut down");
        }
        try {
            return this.getWorkerSelector().next().connect(remoteEndpoint, remoteAddress, localAddress, timeout, attachment, callback);
        }
        catch (IOReactorShutdownException ex) {
            this.initiateShutdown();
            throw ex;
        }
    }

    abstract IOWorkers.Selector getWorkerSelector();
}

