/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark3.agent.lifecycle.plan;

import io.openlineage.client.OpenLineage;
import io.openlineage.spark.api.AbstractQueryPlanInputDatasetBuilder;
import io.openlineage.spark.api.DatasetFactory;
import io.openlineage.spark.api.OpenLineageContext;
import io.openlineage.spark3.agent.utils.DatasetVersionDatasetFacetUtils;
import io.openlineage.spark3.agent.utils.PlanUtils3;
import java.util.List;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceV2RelationInputDatasetBuilder
extends AbstractQueryPlanInputDatasetBuilder<DataSourceV2Relation> {
    private static final Logger log = LoggerFactory.getLogger(DataSourceV2RelationInputDatasetBuilder.class);
    private final DatasetFactory<OpenLineage.InputDataset> factory;

    public DataSourceV2RelationInputDatasetBuilder(OpenLineageContext context, DatasetFactory<OpenLineage.InputDataset> factory) {
        super(context, true);
        this.factory = factory;
    }

    @Override
    public boolean isDefinedAtLogicalPlan(LogicalPlan logicalPlan) {
        return logicalPlan instanceof DataSourceV2Relation;
    }

    @Override
    public List<OpenLineage.InputDataset> apply(DataSourceV2Relation relation) {
        OpenLineage.DatasetFacetsBuilder datasetFacetsBuilder = this.context.getOpenLineage().newDatasetFacetsBuilder();
        DatasetVersionDatasetFacetUtils.includeDatasetVersion(this.context, datasetFacetsBuilder, relation);
        return PlanUtils3.fromDataSourceV2Relation(this.factory, this.context, relation, datasetFacetsBuilder);
    }
}

