/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark3.agent.lifecycle.plan;

import io.openlineage.client.OpenLineage;
import io.openlineage.spark.api.AbstractQueryPlanOutputDatasetBuilder;
import io.openlineage.spark.api.OpenLineageContext;
import io.openlineage.spark3.agent.lifecycle.plan.catalog.IcebergHandler;
import io.openlineage.spark3.agent.utils.DatasetVersionDatasetFacetUtils;
import io.openlineage.spark3.agent.utils.PlanUtils3;
import java.util.List;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.sql.catalyst.analysis.NamedRelation;
import org.apache.spark.sql.catalyst.plans.logical.DeleteFromTable;
import org.apache.spark.sql.catalyst.plans.logical.InsertIntoStatement;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.MergeIntoTable;
import org.apache.spark.sql.catalyst.plans.logical.OverwriteByExpression;
import org.apache.spark.sql.catalyst.plans.logical.OverwritePartitionsDynamic;
import org.apache.spark.sql.catalyst.plans.logical.ReplaceData;
import org.apache.spark.sql.catalyst.plans.logical.UpdateTable;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2ScanRelation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableContentChangeDatasetBuilder
extends AbstractQueryPlanOutputDatasetBuilder<LogicalPlan> {
    private static final Logger log = LoggerFactory.getLogger(TableContentChangeDatasetBuilder.class);

    public TableContentChangeDatasetBuilder(OpenLineageContext context) {
        super(context, false);
    }

    @Override
    public boolean isDefinedAtLogicalPlan(LogicalPlan x) {
        return x instanceof OverwriteByExpression || x instanceof OverwritePartitionsDynamic || x instanceof DeleteFromTable || x instanceof UpdateTable || new IcebergHandler(this.context).hasClasses() && x instanceof ReplaceData || x instanceof MergeIntoTable || x instanceof InsertIntoStatement;
    }

    @Override
    protected List<OpenLineage.OutputDataset> apply(SparkListenerEvent event, LogicalPlan x) {
        DataSourceV2Relation returnTable;
        NamedRelation table;
        boolean includeOverwriteFacet = false;
        if (x instanceof OverwriteByExpression) {
            table = ((OverwriteByExpression)x).table();
            includeOverwriteFacet = true;
        } else if (x instanceof InsertIntoStatement) {
            table = (NamedRelation)((InsertIntoStatement)x).table();
            if (((InsertIntoStatement)x).overwrite()) {
                includeOverwriteFacet = true;
            }
        } else if (new IcebergHandler(this.context).hasClasses() && x instanceof ReplaceData) {
            table = ((ReplaceData)x).table();
        } else if (x instanceof DeleteFromTable) {
            table = (NamedRelation)((DeleteFromTable)x).table();
        } else if (x instanceof UpdateTable) {
            table = (NamedRelation)((UpdateTable)x).table();
        } else if (x instanceof MergeIntoTable) {
            table = (NamedRelation)((MergeIntoTable)x).targetTable();
        } else {
            table = ((OverwritePartitionsDynamic)x).table();
            includeOverwriteFacet = true;
        }
        OpenLineage.DatasetFacetsBuilder datasetFacetsBuilder = this.context.getOpenLineage().newDatasetFacetsBuilder();
        if (includeOverwriteFacet) {
            datasetFacetsBuilder.lifecycleStateChange(this.context.getOpenLineage().newLifecycleStateChangeDatasetFacet(OpenLineage.LifecycleStateChangeDatasetFacet.LifecycleStateChange.OVERWRITE, null));
        }
        DataSourceV2Relation dataSourceV2Relation = returnTable = table instanceof DataSourceV2ScanRelation ? this.castToDataSourceV2Relation(x, table) : (DataSourceV2Relation)table;
        if (this.includeDatasetVersion(event)) {
            DatasetVersionDatasetFacetUtils.includeDatasetVersion(this.context, datasetFacetsBuilder, returnTable);
        }
        return PlanUtils3.fromDataSourceV2Relation(this.outputDataset(), this.context, returnTable, datasetFacetsBuilder);
    }

    private DataSourceV2Relation castToDataSourceV2Relation(LogicalPlan x, NamedRelation table) {
        log.warn("The relation '{}' is of an invalid type 'DataSourceV2ScanRelation', and should not be handled as an output relation. The cast operation will be applied, but the logical plan associated with the relation may contain an unexpected structure: {}", (Object)table.name(), (Object)x);
        return ((DataSourceV2ScanRelation)table).relation();
    }
}

