/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark3.agent.lifecycle.plan.catalog;

import io.openlineage.client.utils.DatasetIdentifier;
import io.openlineage.spark.agent.util.PathUtils;
import io.openlineage.spark.api.OpenLineageContext;
import io.openlineage.spark.shaded.org.apache.commons.lang3.reflect.MethodUtils;
import io.openlineage.spark3.agent.lifecycle.plan.catalog.CatalogHandler;
import io.openlineage.spark3.agent.lifecycle.plan.catalog.DeltaHandler;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;

public abstract class AbstractDatabricksHandler
implements CatalogHandler {
    private static final Logger log = LoggerFactory.getLogger(AbstractDatabricksHandler.class);
    final String databricksClassNameString;
    protected final OpenLineageContext context;

    public AbstractDatabricksHandler(OpenLineageContext context) {
        this(context, "com.databricks.sql.transaction.tahoe.catalog.DeltaCatalog");
    }

    protected AbstractDatabricksHandler(OpenLineageContext context, String databricksClassName) {
        this.context = context;
        this.databricksClassNameString = databricksClassName;
    }

    @Override
    public boolean hasClasses() {
        try {
            DeltaHandler.class.getClassLoader().loadClass(this.databricksClassNameString);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean isClass(TableCatalog tableCatalog) {
        return this.databricksClassNameString.equals(tableCatalog.getClass().getCanonicalName());
    }

    @Override
    public DatasetIdentifier getDatasetIdentifier(SparkSession session, TableCatalog tableCatalog, Identifier identifier, Map<String, String> properties) {
        boolean isPathIdentifier = false;
        try {
            isPathIdentifier = (Boolean)MethodUtils.invokeMethod((Object)tableCatalog, true, "isPathIdentifier", identifier);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        Optional<String> location = isPathIdentifier ? Optional.of(identifier.name()) : Optional.ofNullable(properties.get("location"));
        Path path = new Path(location.orElse(session.sessionState().catalog().defaultTablePath(TableIdentifier.apply((String)identifier.name(), (Option)Option.apply(Arrays.stream(identifier.namespace()).reduce((x, y) -> y).orElse(null)))).toString()));
        log.info(path.toString());
        DatasetIdentifier di = PathUtils.fromPath(path, "file");
        return di.withSymlink(identifier.toString(), StringUtils.substringBeforeLast((String)path.toString(), (String)File.separator), DatasetIdentifier.SymlinkType.TABLE);
    }
}

