/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark3.agent.lifecycle.plan.catalog;

import io.openlineage.client.OpenLineage;
import io.openlineage.client.utils.DatasetIdentifier;
import io.openlineage.spark.api.OpenLineageContext;
import io.openlineage.spark3.agent.lifecycle.plan.catalog.CatalogHandler;
import io.openlineage.spark3.agent.lifecycle.plan.catalog.CosmosHandler;
import io.openlineage.spark3.agent.lifecycle.plan.catalog.DatabricksDeltaHandler;
import io.openlineage.spark3.agent.lifecycle.plan.catalog.DatabricksUnityV2Handler;
import io.openlineage.spark3.agent.lifecycle.plan.catalog.DeltaHandler;
import io.openlineage.spark3.agent.lifecycle.plan.catalog.IcebergHandler;
import io.openlineage.spark3.agent.lifecycle.plan.catalog.JdbcHandler;
import io.openlineage.spark3.agent.lifecycle.plan.catalog.RelationHandler;
import io.openlineage.spark3.agent.lifecycle.plan.catalog.UnsupportedCatalogException;
import io.openlineage.spark3.agent.lifecycle.plan.catalog.V2SessionCatalogHandler;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;

public class CatalogUtils3 {
    private static List<RelationHandler> relationHandlers = CatalogUtils3.getRelationHandlers();

    private static List<CatalogHandler> getHandlers(OpenLineageContext context) {
        List<CatalogHandler> handlers = Arrays.asList(new IcebergHandler(context), new DeltaHandler(context), new DatabricksDeltaHandler(context), new DatabricksUnityV2Handler(context), new JdbcHandler(), new V2SessionCatalogHandler());
        return handlers.stream().filter(CatalogHandler::hasClasses).collect(Collectors.toList());
    }

    private static List<RelationHandler> getRelationHandlers() {
        List<RelationHandler> handlers = Arrays.asList(new CosmosHandler());
        return handlers.stream().filter(RelationHandler::hasClasses).collect(Collectors.toList());
    }

    public static DatasetIdentifier getDatasetIdentifier(OpenLineageContext context, TableCatalog catalog, Identifier identifier, Map<String, String> properties) {
        return CatalogUtils3.getDatasetIdentifier(context, catalog, identifier, properties, CatalogUtils3.getHandlers(context));
    }

    public static DatasetIdentifier getDatasetIdentifier(OpenLineageContext context, TableCatalog catalog, Identifier identifier, Map<String, String> properties, List<CatalogHandler> handlers) {
        return handlers.stream().filter(handler -> handler.isClass(catalog)).filter(handler -> context.getSparkSession().isPresent()).map(handler -> handler.getDatasetIdentifier(context.getSparkSession().get(), catalog, identifier, properties)).findAny().orElseThrow(() -> new UnsupportedCatalogException(catalog.getClass().getCanonicalName()));
    }

    public static Optional<CatalogHandler> getCatalogHandler(OpenLineageContext context, TableCatalog catalog) {
        return CatalogUtils3.getHandlers(context).stream().filter(handler -> handler.isClass(catalog)).findAny();
    }

    public static DatasetIdentifier getDatasetIdentifierFromRelation(DataSourceV2Relation relation) {
        return CatalogUtils3.getDatasetIdentifierFromRelation(relation, relationHandlers);
    }

    public static DatasetIdentifier getDatasetIdentifierFromRelation(DataSourceV2Relation relation, List<RelationHandler> relationHandlers) {
        return relationHandlers.stream().filter(handler -> handler.isClass(relation)).map(handler -> handler.getDatasetIdentifier(relation)).findAny().orElseThrow(() -> new UnsupportedCatalogException(relation.getClass().getCanonicalName()));
    }

    public static Optional<OpenLineage.StorageDatasetFacet> getStorageDatasetFacet(OpenLineageContext context, TableCatalog catalog, Map<String, String> properties) {
        Optional<CatalogHandler> catalogHandler = CatalogUtils3.getCatalogHandler(context, catalog);
        return catalogHandler.isPresent() ? catalogHandler.get().getStorageDatasetFacet(properties) : Optional.empty();
    }

    public static Optional<String> getDatasetVersion(OpenLineageContext context, TableCatalog catalog, Identifier identifier, Map<String, String> properties) {
        Optional<CatalogHandler> catalogHandler = CatalogUtils3.getCatalogHandler(context, catalog);
        return catalogHandler.isPresent() ? catalogHandler.get().getDatasetVersion(catalog, identifier, properties) : Optional.empty();
    }
}

