/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark3.agent.utils;

import io.openlineage.client.OpenLineage;
import io.openlineage.client.OpenLineageClientUtils;
import io.openlineage.client.utils.DatasetIdentifier;
import io.openlineage.spark.shaded.com.fasterxml.jackson.annotation.JsonAnySetter;
import io.openlineage.spark.shaded.com.fasterxml.jackson.core.type.TypeReference;
import io.openlineage.spark.shaded.org.apache.commons.lang3.reflect.FieldUtils;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExtesionDataSourceV2Utils {
    private static final Logger log = LoggerFactory.getLogger(ExtesionDataSourceV2Utils.class);
    public static final String OPENLINEAGE_DATASET_FACETS_PREFIX = "openlineage.dataset.facets.";
    private static Map<String, TypeReference> predefinedFacets = new HashMap<String, TypeReference>();

    ExtesionDataSourceV2Utils() {
    }

    public static void loadBuilder(OpenLineage openLineage, OpenLineage.DatasetFacetsBuilder builder, DataSourceV2Relation relation) {
        Map properties = relation.table().properties();
        predefinedFacets.keySet().stream().filter(field -> properties.containsKey(OPENLINEAGE_DATASET_FACETS_PREFIX + field)).forEach(field -> {
            try {
                Object o = OpenLineageClientUtils.fromJson((String)properties.get(OPENLINEAGE_DATASET_FACETS_PREFIX + field), predefinedFacets.get(field));
                FieldUtils.writeField(builder, field, o, true);
            }
            catch (IllegalAccessException | RuntimeException e) {
                log.warn("Couldn't serialize and assign facet", (Throwable)e);
            }
        });
        properties.keySet().stream().filter(key -> key.startsWith(OPENLINEAGE_DATASET_FACETS_PREFIX)).map(key -> StringUtils.substringAfterLast((String)key, (String)".")).filter(key -> !predefinedFacets.containsKey(key)).forEach(key -> {
            try {
                OpenLineage.DatasetFacet datasetFacet = OpenLineageClientUtils.fromJson((String)properties.get(OPENLINEAGE_DATASET_FACETS_PREFIX + key), new TypeReference<OpenLineage.DatasetFacet>(){});
                builder.put((String)key, ExtesionDataSourceV2Utils.enrichWithProducerUrl(datasetFacet, openLineage.newDatasetFacet().get_producer()));
            }
            catch (RuntimeException e) {
                log.warn("Couldn't serialize and assign facet", (Throwable)e);
            }
        });
    }

    private static OpenLineage.DatasetFacet enrichWithProducerUrl(final OpenLineage.DatasetFacet facet, final URI producerUri) {
        if (facet.get_producer() != null && facet.get_producer().equals(producerUri)) {
            return facet;
        }
        return new OpenLineage.DatasetFacet(){
            URI _producer;
            URI _schemaURL;
            Boolean _deleted;
            @JsonAnySetter
            Map<String, Object> additionalProperties;
            {
                this._producer = producerUri;
                this._schemaURL = facet.get_schemaURL();
                this._deleted = facet.isDeleted();
                this.additionalProperties = facet.getAdditionalProperties();
            }

            @Override
            public URI get_producer() {
                return producerUri;
            }

            @Override
            public URI get_schemaURL() {
                return this._schemaURL;
            }

            @Override
            public Boolean get_deleted() {
                return this._deleted;
            }

            @Override
            public Map<String, Object> getAdditionalProperties() {
                return this.additionalProperties;
            }
        };
    }

    public static DatasetIdentifier getDatasetIdentifier(DataSourceV2Relation relation) {
        return new DatasetIdentifier((String)relation.table().properties().get("openlineage.dataset.name"), (String)relation.table().properties().get("openlineage.dataset.namespace"));
    }

    public static boolean hasExtensionLineage(DataSourceV2Relation relation) {
        return Optional.ofNullable(relation).map(r -> r.table()).map(table -> table.properties()).filter(Objects::nonNull).filter(props -> props.containsKey("openlineage.dataset.name")).filter(props -> props.containsKey("openlineage.dataset.namespace")).isPresent();
    }

    static {
        predefinedFacets.put("documentation", new TypeReference<OpenLineage.DocumentationDatasetFacet>(){});
        predefinedFacets.put("dataSource", new TypeReference<OpenLineage.DatasourceDatasetFacet>(){});
        predefinedFacets.put("version", new TypeReference<OpenLineage.DatasetVersionDatasetFacet>(){});
        predefinedFacets.put("schema", new TypeReference<OpenLineage.SchemaDatasetFacet>(){});
        predefinedFacets.put("ownership", new TypeReference<OpenLineage.OwnershipDatasetFacet>(){});
        predefinedFacets.put("storage", new TypeReference<OpenLineage.StorageDatasetFacet>(){});
        predefinedFacets.put("columnLineage", new TypeReference<OpenLineage.ColumnLineageDatasetFacet>(){});
        predefinedFacets.put("symlinks", new TypeReference<OpenLineage.SymlinksDatasetFacet>(){});
        predefinedFacets.put("lifecycleStateChange", new TypeReference<OpenLineage.LifecycleStateChangeDatasetFacet>(){});
    }
}

