/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark34.agent.lifecycle.plan.column;

import io.openlineage.client.OpenLineage;
import io.openlineage.spark.agent.util.ScalaConversionUtils;
import io.openlineage.spark.api.AbstractQueryPlanInputDatasetBuilder;
import io.openlineage.spark.api.OpenLineageContext;
import io.openlineage.spark.shaded.org.apache.commons.lang3.reflect.MethodUtils;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.sql.catalyst.plans.logical.CreateTable;
import org.apache.spark.sql.catalyst.plans.logical.CreateTableAsSelect;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.ReplaceTable;
import org.apache.spark.sql.catalyst.plans.logical.ReplaceTableAsSelect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateReplaceInputDatasetBuilder
extends AbstractQueryPlanInputDatasetBuilder<LogicalPlan> {
    private static final Logger log = LoggerFactory.getLogger(CreateReplaceInputDatasetBuilder.class);

    public CreateReplaceInputDatasetBuilder(OpenLineageContext context) {
        super(context, false);
    }

    @Override
    public boolean isDefinedAt(SparkListenerEvent event) {
        return true;
    }

    @Override
    public boolean isDefinedAtLogicalPlan(LogicalPlan x) {
        log.debug("Calling isDefinedAtLogicalPlan on {} with children {}", x.getClass(), (Object)x.children());
        return !(!(x instanceof CreateTableAsSelect) && !(x instanceof ReplaceTable) && !(x instanceof ReplaceTableAsSelect) && !(x instanceof CreateTable) || x.children() != null && !x.children().isEmpty());
    }

    @Override
    public List<OpenLineage.InputDataset> apply(SparkListenerEvent event, LogicalPlan x) {
        log.debug("Calling apply on {}", x.getClass());
        return this.extractChildren(x).stream().flatMap(plan -> ScalaConversionUtils.fromSeq(plan.collect(this.delegate(this.context.getInputDatasetQueryPlanVisitors(), this.context.getInputDatasetBuilders(), event))).stream().flatMap(a -> a.stream())).collect(Collectors.toList());
    }

    protected List<LogicalPlan> extractChildren(LogicalPlan x) {
        try {
            Object query = MethodUtils.invokeMethod(x, "query");
            if (query instanceof List) {
                log.debug("Query is a list of size {}", (Object)((List)query).size());
                return ((List)query).stream().filter(o -> o instanceof LogicalPlan).map(o -> (LogicalPlan)o).collect(Collectors.toList());
            }
            if (query instanceof LogicalPlan) {
                return Collections.singletonList((LogicalPlan)query);
            }
        }
        catch (Exception e) {
            log.warn("Failed to extract child query from {}", (Object)x);
        }
        return Collections.emptyList();
    }
}

