/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.sql;

import io.openlineage.spark.shaded.org.apache.commons.lang3.builder.HashCodeBuilder;
import io.openlineage.sql.QuoteStyle;

public class DbTableMeta {
    private final String database;
    private final String schema;
    private final String name;
    private final QuoteStyle quoteStyle;

    public DbTableMeta(String database, String schema, String name, QuoteStyle quoteStyle) {
        this.database = database;
        this.schema = schema;
        this.name = name;
        this.quoteStyle = quoteStyle;
    }

    public DbTableMeta(String database, String schema, String name) {
        this.database = database;
        this.schema = schema;
        this.name = name;
        this.quoteStyle = new QuoteStyle(null, null, null);
    }

    public String database() {
        return this.database;
    }

    public String schema() {
        return this.schema;
    }

    public String name() {
        return this.name;
    }

    public QuoteStyle quote_style() {
        return this.quoteStyle;
    }

    public String qualifiedName() {
        return String.format("%s%s%s", this.database != null ? this.database + "." : "", this.schema != null ? this.schema + "." : "", this.name);
    }

    public String toString() {
        return String.format("\"%s%s%s\"", this.database != null ? this.database + "." : "", this.schema != null ? this.schema + "." : "", this.name);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DbTableMeta)) {
            return false;
        }
        DbTableMeta other = (DbTableMeta)o;
        return this.qualifiedName().equals(other.qualifiedName());
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.database).append(this.schema).append(this.name).toHashCode();
    }
}

