/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.shade.client;

import io.openlineage.spark.shade.client.ConfigPathProvider;
import io.openlineage.spark.shade.client.OpenLineage;
import io.openlineage.spark.shade.client.OpenLineageClientException;
import io.openlineage.spark.shade.client.OpenLineageConfig;
import io.openlineage.spark.shade.com.fasterxml.jackson.annotation.JsonFilter;
import io.openlineage.spark.shade.com.fasterxml.jackson.annotation.JsonInclude;
import io.openlineage.spark.shade.com.fasterxml.jackson.core.JsonFactory;
import io.openlineage.spark.shade.com.fasterxml.jackson.core.JsonProcessingException;
import io.openlineage.spark.shade.com.fasterxml.jackson.core.type.TypeReference;
import io.openlineage.spark.shade.com.fasterxml.jackson.databind.DeserializationFeature;
import io.openlineage.spark.shade.com.fasterxml.jackson.databind.ObjectMapper;
import io.openlineage.spark.shade.com.fasterxml.jackson.databind.SerializationFeature;
import io.openlineage.spark.shade.com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import io.openlineage.spark.shade.com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import io.openlineage.spark.shade.com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.openlineage.spark.shade.com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import io.openlineage.spark.shade.com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OpenLineageClientUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenLineageClientUtils.class);
    private static final ObjectMapper MAPPER = OpenLineageClientUtils.newObjectMapper();
    private static final ObjectMapper YML = OpenLineageClientUtils.newObjectMapper(new YAMLFactory());
    private static final ObjectMapper JSON = OpenLineageClientUtils.newObjectMapper();

    private OpenLineageClientUtils() {
    }

    public static ObjectMapper newObjectMapper() {
        return OpenLineageClientUtils.newObjectMapper(new JsonFactory());
    }

    public static ObjectMapper newObjectMapper(JsonFactory jsonFactory) {
        ObjectMapper mapper = new ObjectMapper(jsonFactory);
        mapper.registerModule(new Jdk8Module());
        mapper.registerModule(new JavaTimeModule());
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        return mapper;
    }

    public static void configureObjectMapper(String ... disableFacets) {
        if (disableFacets == null) {
            return;
        }
        SimpleFilterProvider simpleFilterProvider = new SimpleFilterProvider().addFilter("disabledFacets", SimpleBeanPropertyFilter.serializeAllExcept(disableFacets));
        MAPPER.setFilterProvider(simpleFilterProvider);
        MAPPER.addMixIn(Object.class, DisabledFacetsMixin.class);
    }

    public static String toJson(@NonNull Object value) throws UncheckedIOException {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        try {
            return MAPPER.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <T> T fromJson(@NonNull String json, @NonNull TypeReference<T> type) throws UncheckedIOException {
        if (json == null) {
            throw new NullPointerException("json is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        try {
            return MAPPER.readValue(json, type);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static OpenLineage.RunEvent runEventFromJson(@NonNull String json) throws UncheckedIOException {
        if (json == null) {
            throw new NullPointerException("json is marked non-null but is null");
        }
        return OpenLineageClientUtils.fromJson(json, new TypeReference<OpenLineage.RunEvent>(){});
    }

    public static <T> T convertValue(Object fromValue, Class<T> toValueType) {
        return MAPPER.convertValue(fromValue, toValueType);
    }

    public static <T, F> T mergeFacets(Map<String, F> facetsMap, T facetsContainer, Class<T> klass) {
        if (facetsContainer == null) {
            return MAPPER.convertValue(facetsMap, klass);
        }
        Map targetMap = (Map)MAPPER.convertValue(facetsContainer, new TypeReference<Map<String, F>>(){});
        targetMap.putAll(facetsMap);
        return MAPPER.convertValue((Object)targetMap, klass);
    }

    public static URI toUri(@NonNull String urlString) throws OpenLineageClientException {
        if (urlString == null) {
            throw new NullPointerException("urlString is marked non-null but is null");
        }
        try {
            String urlStringWithNoTrailingSlash = urlString.endsWith("/") ? urlString.substring(0, urlString.length() - 1) : urlString;
            return new URI(urlStringWithNoTrailingSlash);
        }
        catch (URISyntaxException e) {
            throw new OpenLineageClientException("Malformed URI: " + urlString, e);
        }
    }

    public static <T extends OpenLineageConfig> T loadOpenLineageConfigYaml(ConfigPathProvider configPathProvider, TypeReference<T> valueTypeRef) throws OpenLineageClientException {
        try {
            Objects.requireNonNull(configPathProvider);
            List<Path> paths = configPathProvider.getPaths();
            for (Path path : paths) {
                if (!Files.exists(path, new LinkOption[0])) continue;
                return (T)((OpenLineageConfig)YML.readValue(path.toFile(), valueTypeRef));
            }
            String concatenatedPaths = paths.stream().map(Path::toString).collect(Collectors.joining(";", "[", "]"));
            throw new FileNotFoundException("No OpenLineage configuration file found at provided paths, looked in: " + concatenatedPaths);
        }
        catch (NullPointerException e) {
            throw new OpenLineageClientException("ConfigPathProvider was null", e);
        }
        catch (FileNotFoundException e) {
            throw new OpenLineageClientException("No OpenLineage configuration file found", e);
        }
        catch (IOException e) {
            throw new OpenLineageClientException(e);
        }
    }

    public static <T extends OpenLineageConfig> T loadOpenLineageConfigYaml(InputStream inputStream, TypeReference<T> valueTypeRef) throws OpenLineageClientException {
        try {
            return OpenLineageClientUtils.deserializeInputStream(YML, inputStream, valueTypeRef);
        }
        catch (IOException e) {
            log.warn("Error deserializing OpenLineage YAML, falling back to JSON", (Throwable)e);
            return OpenLineageClientUtils.loadOpenLineageConfigJson(inputStream, valueTypeRef);
        }
    }

    public static <T extends OpenLineageConfig> T loadOpenLineageConfigJson(InputStream inputStream, TypeReference<T> valueTypeRef) throws OpenLineageClientException {
        try {
            return OpenLineageClientUtils.deserializeInputStream(JSON, inputStream, valueTypeRef);
        }
        catch (IOException e) {
            throw new OpenLineageClientException(e);
        }
    }

    private static <T extends OpenLineageConfig> T deserializeInputStream(ObjectMapper deserializer, InputStream inputStream, TypeReference<T> valueTypeRef) throws IOException {
        return (T)((OpenLineageConfig)deserializer.readValue(inputStream, valueTypeRef));
    }

    @JsonFilter(value="disabledFacets")
    public class DisabledFacetsMixin {
    }
}

