/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.shade.client;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.openlineage.spark.shade.client.OpenLineage;
import io.openlineage.spark.shade.client.OpenLineageClientUtils;
import io.openlineage.spark.shade.client.circuitBreaker.CircuitBreaker;
import io.openlineage.spark.shade.client.metrics.MicrometerProvider;
import io.openlineage.spark.shade.client.transports.ConsoleTransport;
import io.openlineage.spark.shade.client.transports.Transport;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OpenLineageClient
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenLineageClient.class);
    final Transport transport;
    final Optional<CircuitBreaker> circuitBreaker;
    final MeterRegistry meterRegistry;
    final String[] disabledFacets;
    Counter emitStart;
    Counter emitComplete;
    AtomicInteger engagedCircuitBreaker;
    Timer emitTime;

    public OpenLineageClient() {
        this((Transport)new ConsoleTransport());
    }

    public OpenLineageClient(@NonNull Transport transport) {
        this(transport, new String[0]);
        if (transport == null) {
            throw new NullPointerException("transport is marked non-null but is null");
        }
    }

    public OpenLineageClient(@NonNull Transport transport, String ... disabledFacets) {
        this(transport, (CircuitBreaker)null, (MeterRegistry)null, disabledFacets);
        if (transport == null) {
            throw new NullPointerException("transport is marked non-null but is null");
        }
    }

    public OpenLineageClient(@NonNull Transport transport, CircuitBreaker circuitBreaker, MeterRegistry meterRegistry, String ... disabledFacets) {
        if (transport == null) {
            throw new NullPointerException("transport is marked non-null but is null");
        }
        this.transport = transport;
        this.disabledFacets = Arrays.copyOf(disabledFacets, disabledFacets.length);
        this.circuitBreaker = Optional.ofNullable(circuitBreaker);
        this.meterRegistry = meterRegistry == null ? MicrometerProvider.getMeterRegistry() : meterRegistry;
        this.initializeMetrics();
        OpenLineageClientUtils.configureObjectMapper(disabledFacets);
    }

    public void emit(@NonNull OpenLineage.RunEvent runEvent) {
        if (runEvent == null) {
            throw new NullPointerException("runEvent is marked non-null but is null");
        }
        if (log.isDebugEnabled()) {
            log.debug("OpenLineageClient will emit lineage event: {}", (Object)OpenLineageClientUtils.toJson(runEvent));
        }
        if (this.circuitBreaker.isPresent() && this.circuitBreaker.get().currentState().isClosed()) {
            this.engagedCircuitBreaker.set(1);
            log.warn("OpenLineageClient disabled with circuit breaker");
            return;
        }
        this.engagedCircuitBreaker.set(0);
        this.emitStart.increment();
        this.emitTime.record(() -> this.transport.emit(runEvent));
        this.emitComplete.increment();
    }

    public void emit(@NonNull OpenLineage.DatasetEvent datasetEvent) {
        if (datasetEvent == null) {
            throw new NullPointerException("datasetEvent is marked non-null but is null");
        }
        if (log.isDebugEnabled()) {
            log.debug("OpenLineageClient will emit lineage event: {}", (Object)OpenLineageClientUtils.toJson(datasetEvent));
        }
        if (this.circuitBreaker.isPresent() && this.circuitBreaker.get().currentState().isClosed()) {
            this.engagedCircuitBreaker.set(1);
            log.warn("OpenLineageClient disabled with circuit breaker");
            return;
        }
        this.engagedCircuitBreaker.set(0);
        this.emitStart.increment();
        this.emitTime.record(() -> this.transport.emit(datasetEvent));
        this.emitComplete.increment();
    }

    public void emit(@NonNull OpenLineage.JobEvent jobEvent) {
        if (jobEvent == null) {
            throw new NullPointerException("jobEvent is marked non-null but is null");
        }
        if (log.isDebugEnabled()) {
            log.debug("OpenLineageClient will emit lineage event: {}", (Object)OpenLineageClientUtils.toJson(jobEvent));
        }
        if (this.circuitBreaker.isPresent() && this.circuitBreaker.get().currentState().isClosed()) {
            this.engagedCircuitBreaker.set(1);
            log.warn("OpenLineageClient disabled with circuit breaker");
            return;
        }
        this.engagedCircuitBreaker.set(0);
        this.emitStart.increment();
        this.emitTime.record(() -> this.transport.emit(jobEvent));
        this.emitComplete.increment();
    }

    public void initializeMetrics() {
        this.emitStart = this.meterRegistry.counter("openlineage.emit.start", new String[]{"openlineage.transport", this.transport.getClass().getName()});
        this.emitComplete = this.meterRegistry.counter("openlineage.emit.complete", new String[]{"openlineage.transport", this.transport.getClass().getName()});
        this.engagedCircuitBreaker = (AtomicInteger)this.meterRegistry.gauge("openlineage.circuitbreaker.engaged", Collections.singletonList(Tag.of((String)"openlineage.circuitbreaker", (String)this.circuitBreaker.getClass().getName())), (Number)new AtomicInteger(0));
        this.emitTime = this.meterRegistry.timer("openlineage.emit.time", new String[]{"openlineage.transport", this.transport.getClass().getName()});
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void close() throws Exception {
        this.transport.close();
        this.meterRegistry.close();
    }

    public static final class Builder {
        private static final Transport DEFAULT_TRANSPORT = new ConsoleTransport();
        private Transport transport = DEFAULT_TRANSPORT;
        private String[] disabledFacets = new String[0];
        private CircuitBreaker circuitBreaker;
        private MeterRegistry meterRegistry;

        private Builder() {
        }

        public Builder transport(@NonNull Transport transport) {
            if (transport == null) {
                throw new NullPointerException("transport is marked non-null but is null");
            }
            this.transport = transport;
            return this;
        }

        public Builder circuitBreaker(@NonNull CircuitBreaker circuitBreaker) {
            if (circuitBreaker == null) {
                throw new NullPointerException("circuitBreaker is marked non-null but is null");
            }
            this.circuitBreaker = circuitBreaker;
            return this;
        }

        public Builder meterRegistry(@NonNull MeterRegistry meterRegistry) {
            if (meterRegistry == null) {
                throw new NullPointerException("meterRegistry is marked non-null but is null");
            }
            this.meterRegistry = meterRegistry;
            return this;
        }

        public Builder disableFacets(String ... disabledFacets) {
            if (disabledFacets == null) {
                throw new NullPointerException("disabledFacets is marked non-null but is null");
            }
            this.disabledFacets = Arrays.copyOf(disabledFacets, disabledFacets.length);
            return this;
        }

        public OpenLineageClient build() {
            return new OpenLineageClient(this.transport, this.circuitBreaker, this.meterRegistry, this.disabledFacets);
        }
    }
}

