/*
 * Decompiled with CFR 0.152.
 */
package io.openmanufacturing.sds.aspectmetamodel;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public enum KnownVersion {
    BAMM_1_0_0;


    public String toVersionString() {
        return this.toString().replaceFirst("BAMM_(\\d+)_(\\d+)_(\\d+)", "$1.$2.$3");
    }

    public static Optional<KnownVersion> fromVersionString(String version) {
        return Arrays.stream(KnownVersion.values()).filter(value -> value.toVersionString().equals(version)).findAny();
    }

    public static KnownVersion getLatest() {
        return Arrays.asList(KnownVersion.values()).get(KnownVersion.values().length - 1);
    }

    public static List<KnownVersion> getVersions() {
        return Arrays.asList(KnownVersion.values());
    }

    public boolean isNewerThan(KnownVersion otherVersion) {
        return this.toVersionString().compareTo(otherVersion.toVersionString()) > 0;
    }
}

