/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.connector.api.data;

import io.openmessaging.connector.api.data.EntryType;
import io.openmessaging.connector.api.data.Schema;
import java.util.Arrays;
import java.util.Objects;

public abstract class DataEntry {
    private Long timestamp;
    private EntryType entryType;
    private String queueName;
    private String shardingKey;
    private Schema schema;
    private Object[] payload;

    public DataEntry(Long timestamp, EntryType entryType, String queueName, Schema schema, Object[] payload) {
        this(timestamp, entryType, queueName, schema, null, payload);
    }

    public DataEntry(Long timestamp, EntryType entryType, String queueName, Schema schema, String shardingKey, Object[] payload) {
        this.timestamp = timestamp;
        this.entryType = entryType;
        this.queueName = queueName;
        this.schema = schema;
        this.shardingKey = shardingKey;
        this.payload = payload;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public EntryType getEntryType() {
        return this.entryType;
    }

    public void setEntryType(EntryType entryType) {
        this.entryType = entryType;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public Object[] getPayload() {
        return this.payload;
    }

    public void setPayload(Object[] payload) {
        this.payload = payload;
    }

    public String getShardingKey() {
        return this.shardingKey;
    }

    public void setShardingKey(String shardingKey) {
        this.shardingKey = shardingKey;
    }

    public String toString() {
        return "DataEntry{timestamp=" + this.timestamp + ", entryType=" + (Object)((Object)this.entryType) + ", queueName='" + this.queueName + '\'' + ", shardingKey='" + this.shardingKey + '\'' + ", schema=" + this.schema + ", payload=" + Arrays.toString(this.payload) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataEntry)) {
            return false;
        }
        DataEntry entry = (DataEntry)o;
        return Objects.equals(this.timestamp, entry.timestamp) && this.entryType == entry.entryType && Objects.equals(this.queueName, entry.queueName) && Objects.equals(this.shardingKey, entry.shardingKey) && Objects.equals(this.schema, entry.schema) && Arrays.equals(this.payload, entry.payload);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.timestamp, this.entryType, this.queueName, this.shardingKey, this.schema});
        result = 31 * result + Arrays.hashCode(this.payload);
        return result;
    }
}

