/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.connector.api.data;

import io.openmessaging.connector.api.data.EntryType;
import io.openmessaging.connector.api.data.Field;
import io.openmessaging.connector.api.data.Schema;
import io.openmessaging.connector.api.data.SinkDataEntry;
import io.openmessaging.connector.api.data.SourceDataEntry;
import java.nio.ByteBuffer;

public class DataEntryBuilder {
    private Long timestamp;
    private EntryType entryType;
    private String queueName;
    private String shardingKey;
    private Schema schema;
    private Object[] payload;

    public DataEntryBuilder(Schema schema) {
        this.schema = schema;
        this.payload = new Object[schema.getFields().size()];
    }

    public DataEntryBuilder timestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public DataEntryBuilder entryType(EntryType entryType) {
        this.entryType = entryType;
        return this;
    }

    public DataEntryBuilder queue(String queueName) {
        this.queueName = queueName;
        return this;
    }

    public DataEntryBuilder shardingKey(String shardingKey) {
        this.shardingKey = shardingKey;
        return this;
    }

    public DataEntryBuilder putFiled(String fieldName, Object value) {
        Field field = this.lookupField(fieldName);
        this.payload[field.getIndex()] = value;
        return this;
    }

    public SourceDataEntry buildSourceDataEntry(ByteBuffer sourcePartition, ByteBuffer sourcePosition) {
        return new SourceDataEntry(sourcePartition, sourcePosition, this.timestamp, this.entryType, this.queueName, this.schema, this.shardingKey, this.payload);
    }

    public SinkDataEntry buildSinkDataEntry(Long queueOffset) {
        return new SinkDataEntry(queueOffset, this.timestamp, this.entryType, this.queueName, this.schema, this.shardingKey, this.payload);
    }

    private Field lookupField(String fieldName) {
        Field field = this.schema.getField(fieldName);
        if (field == null) {
            throw new RuntimeException(fieldName + " is not a valid field name");
        }
        return field;
    }
}

