/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.connector.api.data;

import io.openmessaging.connector.api.data.DataEntry;
import io.openmessaging.connector.api.data.EntryType;
import io.openmessaging.connector.api.data.Schema;
import java.nio.ByteBuffer;
import java.util.Objects;

public class SourceDataEntry
extends DataEntry {
    private ByteBuffer sourcePartition;
    private ByteBuffer sourcePosition;

    public SourceDataEntry(ByteBuffer sourcePartition, ByteBuffer sourcePosition, Long timestamp, EntryType entryType, String queueName, Schema schema, Object[] payload) {
        this(sourcePartition, sourcePosition, timestamp, entryType, queueName, schema, null, payload);
    }

    public SourceDataEntry(ByteBuffer sourcePartition, ByteBuffer sourcePosition, Long timestamp, EntryType entryType, String queueName, Schema schema, String shardingKey, Object[] payload) {
        super(timestamp, entryType, queueName, schema, shardingKey, payload);
        this.sourcePartition = sourcePartition;
        this.sourcePosition = sourcePosition;
    }

    public ByteBuffer getSourcePartition() {
        return this.sourcePartition;
    }

    public void setSourcePartition(ByteBuffer sourcePartition) {
        this.sourcePartition = sourcePartition;
    }

    public ByteBuffer getSourcePosition() {
        return this.sourcePosition;
    }

    public void setSourcePosition(ByteBuffer sourcePosition) {
        this.sourcePosition = sourcePosition;
    }

    @Override
    public String toString() {
        return "SourceDataEntry{sourcePartition=" + this.sourcePartition + ", sourcePosition=" + this.sourcePosition + "} " + super.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SourceDataEntry)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SourceDataEntry entry = (SourceDataEntry)o;
        return Objects.equals(this.sourcePartition, entry.sourcePartition) && Objects.equals(this.sourcePosition, entry.sourcePosition);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.sourcePartition, this.sourcePosition);
    }
}

