/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.storage.dledger.cmdline;

import com.alibaba.fastjson.JSON;
import com.beust.jcommander.Parameter;
import io.openmessaging.storage.dledger.client.DLedgerClient;
import io.openmessaging.storage.dledger.cmdline.BaseCommand;
import io.openmessaging.storage.dledger.entry.DLedgerEntry;
import io.openmessaging.storage.dledger.protocol.GetEntriesResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetCommand
extends BaseCommand {
    private static Logger logger = LoggerFactory.getLogger(GetCommand.class);
    @Parameter(names={"--group", "-g"}, description="Group of this server")
    private String group = "default";
    @Parameter(names={"--peers", "-p"}, description="Peer info of this server")
    private String peers = "n0-localhost:20911";
    @Parameter(names={"--index", "-i"}, description="get entry from index")
    private long index = 0L;

    @Override
    public void doCommand() {
        DLedgerClient dLedgerClient = new DLedgerClient(this.group, this.peers);
        dLedgerClient.startup();
        GetEntriesResponse response = dLedgerClient.get(this.index);
        logger.info("Get Result:{}", (Object)JSON.toJSONString((Object)response));
        if (response.getEntries() != null && response.getEntries().size() > 0) {
            for (DLedgerEntry entry : response.getEntries()) {
                logger.info("Get Result index:{} {}", (Object)entry.getIndex(), (Object)new String(entry.getBody()));
            }
        }
        dLedgerClient.shutdown();
    }
}

