/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.storage.dledger.cmdline;

import com.alibaba.fastjson.JSON;
import com.beust.jcommander.Parameter;
import io.openmessaging.storage.dledger.client.DLedgerClient;
import io.openmessaging.storage.dledger.cmdline.BaseCommand;
import io.openmessaging.storage.dledger.protocol.DLedgerResponseCode;
import io.openmessaging.storage.dledger.protocol.LeadershipTransferResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeadershipTransferCommand
extends BaseCommand {
    private static Logger logger = LoggerFactory.getLogger(LeadershipTransferCommand.class);
    @Parameter(names={"--group", "-g"}, description="Group of this server")
    private String group = "default";
    @Parameter(names={"--peers", "-p"}, description="Peer info of this server")
    private String peers = "n0-localhost:20911";
    @Parameter(names={"--leader", "-l"}, description="set the current leader manually")
    private String leaderId;
    @Parameter(names={"--transfereeId", "-t"}, description="Node try to be the new leader")
    private String transfereeId = "n0";
    @Parameter(names={"--term"}, description="current term")
    private long term;

    @Override
    public void doCommand() {
        DLedgerClient dLedgerClient = new DLedgerClient(this.group, this.peers);
        dLedgerClient.startup();
        LeadershipTransferResponse response = dLedgerClient.leadershipTransfer(this.leaderId, this.transfereeId, this.term);
        logger.info("LeadershipTransfer code={}, Result:{}", (Object)DLedgerResponseCode.valueOf(response.getCode()), (Object)JSON.toJSONString((Object)response));
        dLedgerClient.shutdown();
    }
}

